#namespace("site")

	### 返回指定栏目的位置导航
	#sql("ChannelLocation")
		SELECT *
		FROM site_channel chn
		WHERE chn.domain = #para(domain) AND LOCATE(path, #para(path)) = 1
		ORDER BY path
	#end

	### 返回指定栏目的文章总数
	#sql("GetContentSize")
		SELECT ifnull(COUNT(*), 0) cnt
		FROM site_content cont
		WHERE cont.domain = #para(domain) AND cont.channelId = #para(channelId)
	#end

	### 返回年份范围内的文章列表，主要用于站点备份
	#sql("Get_Content_Between_Years")
		SELECT cont.*, chn.code channelCode 
		FROM site_content cont 
		INNER JOIN site_channel chn ON chn.id = cont.channelId
		WHERE cont.domain = #para(domain)
		#if(yearFrom != null) AND YEAR(cont.mdate) >= #para(yearFrom) #end
		#if(yearEnd != null) AND YEAR(cont.mdate) <= #para(yearEnd) #end
	#end

	### 删除年份范围内的文章列表，主要用于站点还原
	#sql("Remove_Content_Between_Years")
		DELETE FROM site_content WHERE domain = #para(domain)
		#if(yearFrom != null) AND YEAR(mdate) >= #para(yearFrom) #end
		#if(yearEnd != null) AND YEAR(mdate) <= #para(yearEnd) #end
	#end
	
	### 返回原栏目信息，主要用于站点备份
	#sql("Backup_Channel")
		SELECT * FROM site_channel WHERE domain = #para(domain) ORDER BY path, sort;
	#end
	
	### 清除原栏目信息，主要用于站点还原
	#sql("Restore_Channel")
		DELETE FROM site_channel WHERE domain = #para(domain);
	#end
	
	### 返回原导航信息，主要用于站点备份
	#sql("Backup_Navi")
		SELECT * FROM site_navi WHERE domain = #para(domain);
	#end
	
	### 清除原导航信息，主要用于站点还原
	#sql("Restore_Navi")
		DELETE FROM site_navi WHERE domain = #para(domain);
	#end
	
	### 返回原导航明细信息，主要用于站点备份
	#sql("Backup_Navi_Item")
		SELECT * FROM site_navi_item WHERE domain = #para(domain);
	#end
	
	### 清除原导航明细信息，主要用于站点还原
	#sql("Restore_Navi_Item")
		DELETE FROM site_navi_item WHERE domain = #para(domain);
	#end
	
	### 返回指定采集任务的明细数据来源地址Hash串，用于文章采集去重判断
	#sql("GetCollectorHash")
		SELECT GROUP_CONCAT(urlHash) AS hashs from site_collector_item WHERE taskId = #para(taskId);
	#end
	
	### 删除采集的文章
	#sql("DelCollectorContent")
		DELETE cont.* 
		FROM site_content cont
		INNER JOIN site_collector_item item ON item.taskId = #para(taskId) AND item.contId = cont.id
	#end
	
	### 删除采集的列表明细
	#sql("DelCollectorItem")
		DELETE FROM site_collector_item
		WHERE taskId = #para(taskId)
	#end
	
	### 返回允许投稿的栏目列表
	#sql("GetConbtChannels")
		SELECT chn.id, chn.caption, comp.caption compCap
		FROM site_channel chn
		INNER JOIN base_comp comp ON comp.domain = chn.domain AND comp.used = 1
		WHERE chn.conbtAble = 1
		ORDER BY comp.domain, chn.code
	#end
	
	### 返回草稿箱文章列表
	#sql("GetDraft")
		SELECT cont.id, cont.channelId, cont.channelCaption, cont.caption, cont.subCaption, cont.content, cont.link, cont.summary, cont.thum, cont.author, cont.cdate, cont.mdate
		, src.channelCaption srcChn, comp.caption srcComp
		FROM site_content cont
		LEFT JOIN site_content src ON src.id = cont.srcId
		LEFT JOIN base_comp comp ON comp.domain = src.domain
		WHERE cont.domain = #para(domain) AND cont.draft = 1
		ORDER BY cont.cdate DESC
	#end
	
	### 后台文章搜索
	#sql("SupSearch")
		SELECT comp.caption compCap, chn.code channelCode, cont.id, cont.domain, cont.caption, cont.cdate, cont.channelCaption channelCap, cont.author
		FROM site_content cont
		INNER JOIN base_comp comp ON comp.domain = cont.domain AND comp.used = 1
		INNER JOIN site_channel chn ON chn.id = cont.channelId
		WHERE cont.used = 1 AND draft = 0 AND cont.domain IN (#(EStr.ids2sqlIn(scope)))
		AND (
		#setLocal(keys = keyword.split(' '))
		#setLocal(byCap = target.indexOf('caption') > -1)
		#setLocal(byCon = target.indexOf('content') > -1)
		#for(k : keys)
			#if(for.index > 0) #(mode) #end
			(
				#if(byCap) cont.caption LIKE '%#(k)%' #end
				#if(byCon) OR cont.content LIKE '%#(k)%' #end
			)
		#end
		)
		#if(EStr.notEmpty(fdate)) AND cont.cdate >= '#(fdate) 00:00:00' #end
		#if(EStr.notEmpty(edate)) AND cont.cdate <= '#(edate) 23:59:59' #end
		ORDER BY cont.domain, cont.channelId, cont.cdate
	#end

#end