#namespace("main")

	### 根据部门路径返回所有上级部门
	#sql("getParentDeptByPath")
		SELECT * 
		FROM base_dept 
		WHERE domain = #para(domain) AND used = 1 AND logic = 0 AND '#(path)' LIKE concat(path, '_%')
		#if(EStr.notEmpty(typeCode)) AND typeCode IN (#(EStr.ids2sqlIn(typeCode))) #end
		ORDER BY path #(sort)
	#end

	### 获取访问统计
	#sql("getCountor")
		SELECT IFNULL(SUM(cnt), 0) cnt FROM base_counter
		WHERE domain = #para(domain) AND moduleCode = #para(moduleCode) AND FIND_IN_SET('#(key)', `key`) > 0;
	#end

	### 获取用户离职天数
	#sql("userLeavedDays")
		SELECT IFNULL(SUM(leavedDays), 0) AS cnt FROM base_leaved
		WHERE uid = #para(uid)
	#end

	### 获取系统默认参数列表
	#sql("getConfigList")
		SELECT def.code, def.caption, def.type, cfg.id, ifnull(cfg.value, def.value) value
		FROM base_config_default def
		LEFT JOIN base_config cfg ON cfg.domain=#para(domain) AND cfg.code=def.code
		WHERE def.used=1 AND def.groupId=#para(groupId)
		ORDER BY def.sort, def.id;
	#end
	
	### 获取系统默认参数的各租户设置值列表
	#sql("getCompsVal")
		SELECT comp.domain, comp.caption, cfg.value
		FROM base_comp comp
		LEFT JOIN base_config cfg ON cfg.code = #para(code) AND cfg.domain = comp.domain
		WHERE comp.used = 1
	#end
	
	### 还原指定租户的参数默认值
	#sql("cleanCompsVal")
		DELETE FROM base_config WHERE code = #para(code) AND domain IN (#(domains));
	#end
	
	### 清除指定模块的菜单
	#sql("cleanMenuByModule")
		DELETE FROM base_menu WHERE domain = #para(domain) AND moduleCode = #para(moduleCode);
	#end
	
	### 清除指定路径的菜单，包含子菜单
	#sql("delMenuByPath")
		DELETE FROM base_menu WHERE domain = #para(domain) AND mtype = #para(mtype) AND path LIKE #para(path + "%");
	#end
	
	### 根据关键字搜索用户
	#sql("FindByKeyword")
		SELECT id, domain, idNum, num, member, `type`, caption, phone, phoneVali, email, emailVali, loginName, level, deptId, postId, coef, roleIds, header, remark, birthday, sex, locked, lockTime, cdate, mdate
		FROM base_user
		WHERE domain = #para(domain) AND level <= #para(level) AND used = 1
		#if(EStr.notEmpty(deptId)) AND deptId = #para(deptId) #end
		#if(EStr.notEmpty(type)) AND `type` = #para(type) #end
		#if(EStr.notEmpty(member)) AND member = #para(member) #end
		#if(EStr.notEmpty(fieldName) && EStr.notEmpty(keyword))
			#if(mode == 'equals') AND #(fieldName) = #para(keyword) 
			#else AND #(fieldName) LIKE #para("%" + keyword + "%") #end
		#end
	#end
	
	### 返回默认的账号方案列表
	#sql("GetDefAccountPolicy")
		SELECT acc.*
		FROM base_policy_account acc
		WHERE acc.moduleCode = #para(moduleCode) AND acc.used = 1
			AND (
				acc.domain = #para(domain)
				OR (acc.domain IS NULL AND NOT EXISTS (SELECT id FROM base_policy_account WHERE domain = #para(domain) AND code = acc.code))
			)
	#end
	
	### 获取账号方案的各租户设置值列表
	#sql("GetGlobalPolicyAccount")
		SELECT comp.domain compDomain, comp.caption compCap, policy.*
		FROM base_comp comp
		LEFT JOIN base_policy_account policy ON policy.code = #para(code) AND policy.domain = comp.domain
		WHERE comp.used = 1
		ORDER BY policy.id DESC, comp.id
	#end

#end