package itez.weixin.oplat;

import java.util.concurrent.Callable;

import itez.core.util.RetryUtils;
import itez.kit.EHttp;
import itez.weixin.api.ApiConfig;
import itez.weixin.api.ApiConfigKit;

/**
 * 认证并获取 access_token API
 * https://developers.weixin.qq.com/doc/oplatform/Website_App/WeChat_Login/Wechat_Login.html
 */
@SuppressWarnings("unused")
public class AccessTokenApi {

	// 获取新的access_token
	private static String creAccessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
	// 刷新access_token
    private static String refAccessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=%s&grant_type=refresh_token&refresh_token=%s";

    /**
     * <p>
     * 获取access_token
     * </p>
     * 
     * @param code 用户扫码之后返回的一次性授权码
     * @return
     */
    public static AccessToken getAccessToken(String code) {
        ApiConfig ac = ApiConfigKit.getApiConfig();
        return getAccessToken(ac.getAppId(), ac.getAppSecret(), code);
    }

    /**
     * <p>
     * 获取access_token
     * </p>
     * 
     * @param appid
     * @param secret
     * @param code
     * @return
     */
    public static AccessToken getAccessToken(String appid, String secret, String code){
    	String url = String.format(creAccessTokenUrl, appid, secret, code);
        return RetryUtils.retryOnException(3, new Callable<AccessToken>() {
            @Override
            public AccessToken call() throws Exception {
                String json = EHttp.me.get(url);
                return new AccessToken(json);
            }
        });
    }

}
