package itez.weixin.oplat;

import java.io.Serializable;
import java.util.Map;

import itez.core.util.RetryUtils.ResultCheck;
import itez.kit.EJson;

/**
 * 封装 access_token
 */
@SuppressWarnings("unchecked")
public class AccessToken implements ResultCheck, Serializable {
	
	private static final long serialVersionUID = 2013966423232570925L;
	
	/**
	 * 正确获取到 access_token 时有值
	 */
	private String access_token;    // 接口调用凭证
    private Integer expires_in;     // access_token接口调用凭证超时时间，单位（秒）
	private String refresh_token;	// 刷新 access_token 时使用
	private String openid;			// 授权用户唯一标识
	private String scope;			// 用户授权的作用域，使用逗号（,）分隔
	private String unionid;			// 当且仅当该网站应用已获得该用户的userinfo授权时，才会出现该字段。
	
	/**
	 * 出错时有值
	 */
    private Integer errcode;        // 错误代码
    private String errmsg;          // 错误描述

    /**
     * 扩展参数
     */
    private Long expiredTime;       // 正确获取到 access_token 时有值，存放过期时间
    private String json;

    public AccessToken(String jsonStr) {
        this.json = jsonStr;
        try {
            Map<String, Object> temp = EJson.parse(jsonStr, Map.class);
            access_token = (String) temp.get("access_token");
            expires_in = (Integer) temp.get("expires_in");
            refresh_token = (String) temp.get("refresh_token");
            openid = (String) temp.get("openid");
            scope = (String) temp.get("scope");
            unionid = (String) temp.get("unionid");
            errcode = (Integer) temp.get("errcode");
            errmsg = (String) temp.get("errmsg");

            if (expires_in != null) expiredTime = System.currentTimeMillis() + ((expires_in - 5) * 1000);
            if (temp.containsKey("expiredTime")) expiredTime = (Long) temp.get("expiredTime");

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getJson() {
        return json;
    }

    public String getCacheJson() {
        Map<String, Object> temp = EJson.parse(json, Map.class);
        temp.put("expiredTime", expiredTime);
        temp.remove("expires_in");
        return EJson.toJson(temp);
    }

    public boolean isAvailable() {
        if (expiredTime == null)
            return false;
        if (errcode != null)
            return false;
        if (expiredTime < System.currentTimeMillis())
            return false;
        return access_token != null;
    }

    public String getAccessToken() {
        return access_token;
    }

    public Integer getExpiresIn() {
        return expires_in;
    }

    public Long getExpiredTime() {
        return expiredTime;
    }

	public String getRefreshToken() {
		return refresh_token;
	}

	public String getOpenid() {
		return openid;
	}

	public String getScope() {
		return scope;
	}

	public String getUnionid() {
		return unionid;
	}

	public Integer getErrcode() {
		return errcode;
	}

	public String getErrmsg() {
		return errmsg;
	}

	public Integer getErrorCode() {
        return errcode;
    }

    @Override
    public boolean matching() {
        return isAvailable();
    }
}
