package itez.weixin.msga;

import java.lang.reflect.Field;
import java.text.ParseException;

import com.jfinal.core.converter.TypeConverter;

import itez.weixin.utils.XmlHelper;

public class XmlMsgParser extends MsgModelParser implements IMsgParser {

	@Override
	public WxaMsg parser(String msgStr) {
		XmlHelper xmlHelper = XmlHelper.of(msgStr);
		MsgModel msgModel = toMsgModel(xmlHelper);
		return parserMsg(msgModel);
	}

	private static MsgModel toMsgModel(XmlHelper xmlHelper) {
		MsgModel msgModel = new MsgModel();
		Field[] fields = MsgModel.class.getDeclaredFields();
		for (Field field : fields) {
			XPath xpathAnno = field.getAnnotation(XPath.class);
			if (xpathAnno == null) {
				continue;
			}
			
			String xpath    = xpathAnno.value();
			Class<?> type   = field.getType();
			String strValue = xmlHelper.getString(xpath);
			
			Object value = convert(type, strValue);
			if (!field.isAccessible()) {
				field.setAccessible(true);
			}
			try {
				field.set(msgModel, value);
			} catch (IllegalArgumentException e) {
				throw new RuntimeException(e);
			} catch (IllegalAccessException e) {
				throw new RuntimeException(e);
			}
		}
		return msgModel;
	}
	
	private static final Object convert(Class<?> type, String s) {
		try {
			return TypeConverter.me().convert(type, s);
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}

}
