package itez.weixin.msga;

public class MsgModelParser {

	private static enum MsgType {
		text, image, event
	}
	
	protected WxaMsg parserMsg(MsgModel msgModel) {
		String msgTypeStr = msgModel.getMsgType().toLowerCase();
		MsgType msgType = MsgType.valueOf(msgTypeStr);
		if (MsgType.text == msgType) {
			return new WxaMsgText(msgModel);
		}
		if (MsgType.image == msgType) {
			return new WxaMsgImage(msgModel);
		}
		if (MsgType.event == msgType) {
			if ("user_enter_tempsession".equalsIgnoreCase(msgModel.getEvent())) {
				return new WxaMsgUserEnter(msgModel);
			}
		}
		throw new RuntimeException("暂不支持该类型的小程序消息！");
	}

}
