package itez.weixin.api.app;

import itez.weixin.api.AccessTokenApi;
import itez.weixin.api.ApiResult;
import itez.weixin.utils.HttpUtils;

/**
 * 微信小程序模版消息
 * @author L.cm
 *
 */
public class WxaTemplateApi {
    private static String sendApiUrl = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token=";

    /**
     * 发送模板消息
     * @param jsonStr 模版json
     * @return {ApiResult}
     */
    public static ApiResult send(String jsonStr) {
        String jsonResult = HttpUtils.post(sendApiUrl + AccessTokenApi.getAccessTokenStr(), jsonStr);
        return new ApiResult(jsonResult);
    }

    /**
     * 发送模板消息
     * @param template 模版对象
     * @return {ApiResult}
     */
    public static ApiResult send(WxaTemplate template) {
        return send(template.build());
    }
    
}
