package itez.weixin.api.app;

import itez.kit.EJson;
import itez.weixin.api.AccessTokenApi;
import itez.weixin.api.ApiResult;
import itez.weixin.kit.ParaMap;
import itez.weixin.utils.HttpUtils;

/**
 * 微信二维码api
 * @author L.cm
 *
 */
public class WxaQrcodeApi {
    // 文档地址:https://mp.weixin.qq.com/debug/wxadoc/dev/api/qrcode.html
    private static String createWxaQrcodeURL = "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=";

    /**
     * 获取小程序页面二维码
     *
     * 通过该接口，仅能生成已发布的小程序的二维码。
     * 可以在开发者工具预览时生成开发版的带参二维码。
     * 带参二维码只有 100000 个，请谨慎调用。
     *
     * width 默认430
     * @param path 不能为空，最大长度 128 字节
     * @return ApiResult
     */
    public ApiResult createQrcode(String path) {
        return createQrcode(path, 430);
    }

    /**
     * 获取小程序页面二维码
     *
     * 通过该接口，仅能生成已发布的小程序的二维码。
     * 可以在开发者工具预览时生成开发版的带参二维码。
     * 带参二维码只有 100000 个，请谨慎调用。
     *
     * @param path 不能为空，最大长度 128 字节
     * @param width 默认430 二维码的宽度
     * @return ApiResult
     */
    public ApiResult createQrcode(String path, int width) {
        String url = createWxaQrcodeURL + AccessTokenApi.getAccessTokenStr();
        ParaMap pm = ParaMap.create("path", path).put("width", String.valueOf(width));
        return new ApiResult(HttpUtils.post(url, EJson.toJson(pm.getData())));
    }
}
