package itez.weixin.api.app;

import java.util.HashMap;
import java.util.Map;

import itez.kit.EJson;
import itez.weixin.api.AccessTokenApi;
import itez.weixin.api.ApiResult;
import itez.weixin.utils.HttpUtils;

public class WxaMessageApi {
	
    private static String customMessageUrl = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";

    /**
     * 发送客服消息
     * @param message 消息封装
     * @return ApiResult
     */
    private ApiResult sendMsg(Map<String, Object> message) {
        String accessToken = AccessTokenApi.getAccessTokenStr();
        String jsonResult = HttpUtils.post(customMessageUrl + accessToken, EJson.toJson(message));
        return new ApiResult(jsonResult);
    }
    
    /**
     * 发送文本客服消息
     * @param openId openId
     * @param text 文本消息
     * @return ApiResult
     */
    public ApiResult sendText(String openId, String text) {
        Map<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "text");

        Map<String, Object> textObj = new HashMap<String, Object>();
        textObj.put("content", text);

        json.put("text", textObj);
        return sendMsg(json);
    }

    /**
     * 发送图片消息
     * @param openId openId
     * @param mediaId 图片媒体id
     * @return ApiResult
     */
    public ApiResult sendImage(String openId, String mediaId) {
        Map<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "image");

        Map<String, Object> image = new HashMap<String, Object>();
        image.put("media_id", mediaId);

        json.put("image", image);
        return sendMsg(json);
    }

    /**
     * 发送图文链接消息
     * @param openId openId
     * @param title 消息标题
     * @param description 图文链接消息
     * @param url 图文链接消息被点击后跳转的链接
     * @param thumb_url 图文链接消息的图片链接，支持 JPG、PNG 格式，较好的效果为大图 640 X 320，小图 80 X 80
     * @return
     */
    public ApiResult sendLink(String openId, String title, String description, String url, String thumb_url) {
        Map<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "link");

        Map<String, Object> link = new HashMap<String, Object>();
        link.put("title", title);
        link.put("description", description);
        link.put("url", url);
        link.put("thumb_url", thumb_url);

        json.put("link", link);
        return sendMsg(json);
    }

}
