package itez.weixin.api;

import itez.weixin.cache.DefaultAccessTokenCache;
import itez.weixin.cache.IAccessTokenCache;

/**
 * 将 ApiConfig 绑定到 ThreadLocal 的工具类，以方便在当前线程的各个地方获取 ApiConfig 对象：
 * 1：如果控制器继承自 MsgController 该过程是自动的，详细可查看 MsgInterceptor 与之的配合
 * 2：如果控制器继承自 ApiController 该过程是自动的，详细可查看 ApiInterceptor 与之的配合
 * 3：如果控制器没有继承自 MsgController、ApiController，则需要先手动调用
 *    ApiConfigKit.setThreadLocalAppId(appId) 来绑定 appId 到线程之上
 */
public class ApiConfigKit {

    private static final ThreadLocal<ApiConfig> TL = new ThreadLocal<ApiConfig>();
    
    //配置类型：MP（微信公众号）；APP（微信小程序）；OP（微信开放平台）；ENT（微信企业号）
    public static enum ConfigType { MP, APP, OP, ENT }
    
    public static void setApiConfig(ApiConfig config){
    	TL.set(config);
    }

    public static ApiConfig getApiConfig() {
    	ApiConfig config = TL.get();
        return config;
    }
    
    public static void removeApiConfig(){
    	TL.remove();
    }

    static IAccessTokenCache accessTokenCache = new DefaultAccessTokenCache();

    public static void setAccessTokenCache(IAccessTokenCache accessTokenCache) {
        ApiConfigKit.accessTokenCache = accessTokenCache;
    }

    public static IAccessTokenCache getAccessTokenCache() {
        return ApiConfigKit.accessTokenCache;
    }
    
}
