package itez.plat.wrapper.service;

import java.sql.SQLException;
import java.util.List;

import com.jfinal.plugin.activerecord.IAtom;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.EModel;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EArr;
import itez.kit.EStr;

public abstract class ETreeService<M extends EModel<M>> extends EModelService<M> {
	
	public M getLast(String pid){
		return getLast(null, pid);
	}
	
	public M getLast(Querys qs, String pid){
		Querys querys = Querys.and();
		if(qs != null) querys.add(qs);
		querys.add(EStr.isEmpty(pid) ? Query.nu("pid") : Query.eq("pid", pid));
		return selectFirst(querys, "sort desc");
	}

	public M getPerv(Querys qs, String pid, Integer sort){
		Querys querys = Querys.and();
		if(qs != null) querys.add(qs);
		querys.add(EStr.isEmpty(pid) ? Query.nu("pid") : Query.eq("pid", pid)).add(Query.lt("sort", sort));
		return selectFirst(querys, "sort desc");
	}

	public M getNext(Querys qs, String pid, Integer sort){
		Querys querys = Querys.and();
		if(qs != null) querys.add(qs);
		querys.add(EStr.isEmpty(pid) ? Query.nu("pid") : Query.eq("pid", pid)).add(Query.gt("sort", sort));
		return selectFirst(querys, "sort");
	}
	
	public List<M> getByIds(String ids, String orderby){
		Querys qs = Querys.and(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs, "sort " + orderby);
	}
	
	public void sort(String pid, String opt, String ids){
		sort(null, pid, opt, ids);
	}
	
	public void sort(Querys qs, String pid, String opt, String ids){
		List<M> list = getByIds(ids, opt.equals("up") ? "asc" : "desc");
		if(opt.equals("up")){
			M perv = getPerv(qs, pid, list.get(0).getInt("sort"));
			if(perv == null) return;
		}else{
			M next = getNext(qs, pid, list.get(0).getInt("sort"));
			if(next == null) return;
		}
		list.forEach(item -> {
			sort(qs, pid, opt, item);
		});
	}
	
	private void sort(Querys qs, String pid, String opt, M item){
		M side = opt.equals("up") ? getPerv(qs, pid, item.getInt("sort")) : getNext(qs, pid, item.getInt("sort"));
		Integer sideSort = side.getInt("sort");
		String sidePath = side.get("path");
		Integer itemSort = item.getInt("sort");
		String itemPath = item.get("path");
		item.set("sort", sideSort);
		item.set("path", sidePath);
		side.set("sort", itemSort);
		side.set("path", itemPath);
		update(item);
		update(side);
		Querys qsSide = Querys.and().add(Query.like("path", sidePath + "_%"));
		Querys qsItem = Querys.and().add(Query.like("path", itemPath + "_%"));
		if(qs != null){
			qsSide.add(qs);
			qsItem.add(qs);
		}
		List<M> listSide = select(qsSide);
		listSide.forEach(d -> {
			d.set("path", d.getStr("path").replace(sidePath, itemPath));
		});
		List<M> listItem = select(qsItem);
		listItem.forEach(d -> {
			d.set("path", d.getStr("path").replace(itemPath, sidePath));
		});
		dbo().tx(new IAtom() {
			@Override
			public boolean run() throws SQLException {
				int[] b1 = dbo().batchUpdate(listSide, listSide.size());
				int[] b2 = dbo().batchUpdate(listItem, listItem.size());
				return EArr.vali(b1, b2);
			}
		});
	}
	
}
