package itez.plat.wrapper.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.runtime.service.Ioc;
import itez.kit.exception.ErrException;
import itez.plat.main.model.CompWx;
import itez.plat.main.service.CompWxService;
import itez.weixin.api.ApiConfig;
import itez.weixin.api.ApiConfigKit;
import itez.weixin.api.ApiConfigKit.ConfigType;

public class WxaMsgInterceptor implements Interceptor {

	@Override
	public void intercept(Invocation inv) {
		ConfigType type = ConfigType.OP;
		CompWxService wxs = Ioc.get(CompWxService.class);
		CompWx wx = wxs.getByDomain(type.name());
		if(wx == null) throw new ErrException("未配置该AppId对应的微信端接口参数！");
		ApiConfig ac = new ApiConfig(wx.getToken(), wx.getAppId(), wx.getAppSecret(), wx.getEncryptMessage() == 1, wx.getEncodingAesKey()).setType(type);

		try {
			ApiConfigKit.setApiConfig(ac);
			inv.invoke();
		}finally {
			ApiConfigKit.removeApiConfig();
		}
	}

}
