package itez.plat.wrapper.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.core.runtime.service.common.IComp;
import itez.core.runtime.service.common.ICompService;
import itez.core.runtime.session.EAttr;
import itez.kit.EStr;
import itez.kit.exception.ErrException;
import itez.plat.main.model.CompWx;
import itez.plat.main.service.CompWxService;
import itez.weixin.api.ApiConfig;
import itez.weixin.api.ApiConfigKit;

public class WxaInterceptor implements Interceptor {

	@Override
	public void intercept(Invocation inv) {
		
		EAttr attr = EContext.getAttr();
		if(attr.getIsWxa() && EStr.notEmpty(attr.getWxaAppId())){
			String appId = attr.getWxaAppId();
			CompWxService wxs = Ioc.get(CompWxService.class);
			ICompService cs = Ioc.getComp();
			CompWx wx = wxs.findByAppId(appId);
			if(wx == null) throw new ErrException("未配置该AppId对应的微信端接口参数！");
			
			IComp comp = cs.findByDomain(wx.getDomain());
			EContext.getAttr().changeComp(comp);
			
			ApiConfig ac = new ApiConfig(wx.getToken(), wx.getAppId(), wx.getAppSecret());
			ac.setEncryptMessage(wx.getEncryptMessage() == 1);
			if(ac.isEncryptMessage()) ac.setEncodingAesKey(wx.getEncodingAesKey());
			
			try {
				ApiConfigKit.setApiConfig(ac);
				inv.invoke();
			}finally {
				ApiConfigKit.removeApiConfig();
			}
			
		}else{
			throw new ErrException("未发现AppId！");
		}
		
	}

}
