package itez.plat.wrapper.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.kit.exception.ErrException;
import itez.plat.main.model.CompWx;
import itez.plat.main.service.CompWxService;
import itez.weixin.api.ApiConfig;
import itez.weixin.api.ApiConfigKit;
import itez.weixin.api.ApiConfigKit.ConfigType;

public class WxOplatInterceptor implements Interceptor {

	// 非微信环境，生成登录二维码地址
	String urlOp = "https://open.weixin.qq.com/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_login&state=%s#wechat_redirect";
	// 微信环境，直接唤起授权地址
	String urlMp = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=%s#wechat_redirect";
	
	@Override
	public void intercept(Invocation inv) {
		boolean wxClient = EContext.getAttr().getIsWx();
		CompWxService wxSer = Ioc.get(CompWxService.class);
		ConfigType type = wxClient ? ConfigType.MP : ConfigType.OP;
		CompWx wx = wxSer.getByDomain(type.name());
		if(wx == null) throw new ErrException("未配置该AppId对应的微信端接口参数！");
		ApiConfig ac = new ApiConfig(wx.getToken(), wx.getAppId(), wx.getAppSecret(), wx.getEncryptMessage() == 1, wx.getEncodingAesKey()).setType(type);;
		inv.getController().setAttr("authUrl", wxClient ? urlMp : urlOp);
		try {
			ApiConfigKit.setApiConfig(ac);
			inv.invoke();
		}finally {
			ApiConfigKit.removeApiConfig();
		}
	}

}
