package itez.plat.wrapper.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.session.EAttr;
import itez.plat.msg.service.UserService;

public class MsgInterceptor implements Interceptor {

	@Override
	public void intercept(Invocation inv) {
		EAttr attr = EContext.getAttr();
		Integer unread = 0;
		if(EContext.getSession().getLogined()){
			IUser user = EContext.getSession().getUser();
			UserService msgUserSer = Ioc.get(UserService.class);
			unread = msgUserSer.getUnreadCount(user.getId(), user.getCaption());
		}
		attr.setItem("MsgUnreadCount", unread);

		inv.invoke();
	}

}
