package itez.plat.wrapper.controller;

import com.jfinal.aop.Before;
import com.jfinal.aop.Clear;
import com.jfinal.core.NotAction;

import itez.core.wrapper.controller.EController;
import itez.core.wrapper.controller.HTTP;
import itez.core.wrapper.interceptor.AuthInterceptor;
import itez.kit.EStr;
import itez.plat.wrapper.interceptor.MenuInterceptor;
import itez.plat.wrapper.interceptor.WxaMsgInterceptor;
import itez.weixin.api.ApiConfigKit;
import itez.weixin.kit.MsgEncryptKit;
import itez.weixin.kit.SignatureCheckKit;
import itez.weixin.msga.IMsgParser;
import itez.weixin.msga.WxaMsg;
import itez.weixin.msga.WxaMsgImage;
import itez.weixin.msga.WxaMsgKit;
import itez.weixin.msga.WxaMsgText;
import itez.weixin.msga.WxaMsgUserEnter;

@Clear({ AuthInterceptor.class, MenuInterceptor.class})
@Before(WxaMsgInterceptor.class)
public abstract class EControllerWxaMsg extends EController {

    protected static final String IN_MSG_XML_WXA_CACHE_KEY = "_IN_MSG_XML_WXA_CACHE_KEY_";
    protected static final String IN_MSG_WXA_CACHE_KEY = "_IN_MSG_WXA_CACHE_KEY_";

    public void index() {
    	HTTP method = getMethod();
    	if(method == HTTP.GET){ //首次验证token
        	String signature = getPara("signature");
        	String timestamp = getPara("timestamp");
        	String nonce = getPara("nonce");
        	String echostr = getPara("echostr");
        	if(SignatureCheckKit.me.checkSignature(signature, timestamp, nonce)){
            	renderText(echostr);
        	}else{
        		renderText("签名校验失败！");
        	}
    	}else{ //接收消息
            WxaMsg wxaMsg = getWxaMsg();
            if (wxaMsg instanceof WxaMsgText) {
                processTextMsg((WxaMsgText) wxaMsg);
            } else if (wxaMsg instanceof WxaMsgImage) {
                processImageMsg((WxaMsgImage) wxaMsg);
            } else if (wxaMsg instanceof WxaMsgUserEnter) {
                processUserEnterSessionMsg((WxaMsgUserEnter) wxaMsg);
            }
            renderText("success");
    	}
    }
    
    @NotAction
    public WxaMsg getWxaMsg() {
        WxaMsg wxaMsg = getAttr(IN_MSG_WXA_CACHE_KEY);
        if (wxaMsg == null) {
        	IMsgParser msgParser = WxaMsgKit.me.getMsgParser();
            wxaMsg = msgParser.parser(getWxaMsgXml());
            setAttr(IN_MSG_WXA_CACHE_KEY, wxaMsg);
        }
        return wxaMsg;
    }
    
    @NotAction
    public String getWxaMsgXml() {
        String wxaMsgXml = getAttr(IN_MSG_XML_WXA_CACHE_KEY);
        if (wxaMsgXml == null) {
        	wxaMsgXml = getRawData();
            setAttr(IN_MSG_XML_WXA_CACHE_KEY, wxaMsgXml);
            // 是否需要解密消息
            if (ApiConfigKit.getApiConfig().isEncryptMessage()) {
                wxaMsgXml = MsgEncryptKit.decrypt(wxaMsgXml, getPara("timestamp"), getPara("nonce"), getPara("msg_signature"));
            }
        }
        if (EStr.isEmpty(wxaMsgXml)) {
            throw new RuntimeException("请不要在浏览器中请求该连接,调试请查看WIKI:http://git.oschina.net/jfinal/jfinal-weixin/wikis/JFinal-weixin-demo%E5%92%8C%E8%B0%83%E8%AF%95");
        }
        return wxaMsgXml;
    }
    
    /**
     * 处理接收到的文本消息
     * @param textMsg 处理接收到的文本消息
     */
    protected abstract void processTextMsg(WxaMsgText textMsg);
    
    /**
     * 处理接收到的图片消息
     * @param imageMsg 处理接收到的图片消息
     */
    protected abstract void processImageMsg(WxaMsgImage imageMsg);
    
    /**
     * 处理接收到的进入会话事件
     * @param userEnterSessionMsg 处理接收到的进入会话事件
     */
    protected abstract void processUserEnterSessionMsg(WxaMsgUserEnter userEnterSessionMsg);

}
