package itez.plat.wrapper.controller;

import java.util.concurrent.TimeUnit;

import com.jfinal.aop.Clear;

import itez.core.runtime.auth.AuthRequire;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.session.TokenManager;
import itez.core.wrapper.controller.EController;
import itez.kit.ECookie;
import itez.kit.ERet;

@AuthRequire.Logined
public abstract class EControllerAuth extends EController {

	/**
	 * 获取Token
	 */
	@Clear
	public void getToken(){
		String token = session().getToken();
		renderJson(ERet.create("token", token));
	}

	/**
	 * 存储Token到Cookie
	 */
	@Clear
	public void keepToken(){
		String token = session().getToken();
		ECookie.setCookie(response(), TokenManager.me.getCookieKey(), token, -1, TimeUnit.MINUTES);
		renderJson(ERet.create("token", token));
	}

	/**
	 * 校验Token是否已登录
	 */
	@Clear
	public void valiToken(){
		boolean logined = session().getLogined();
		IUser user = session().getUser();
		ERet ret = logined ? ERet.ok() : ERet.fail();
		renderJson(ret.set("user", user));
	}
	
}
