package itez.plat.source.controller;

import java.util.Arrays;
import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.EStr;
import itez.plat.main.model.User;
import itez.plat.main.model.Vert;
import itez.plat.source.model.DataBase;
import itez.plat.source.plugins.SourceService;
import itez.plat.source.plugins.rdb.database.DataBaseService;

@ControllerDefine(key = "/database", summary = "业务数据库", view = "/rdb")
@AuthRequire.Logined
public class DataBaseController extends EController {

	@Inject
	SourceService dss;

	@Inject
	DataBaseService dbs;
	
	public void index(){
		List<DataBase> list = dbs.getAllDataBase();
		setAttr("dbTypeList", dbs.getDbTypeList());
		setAttr("accessList", dss.getAccessList());
		setAttr("dataBases", list);
		render("dataBase.html");
	}
	
	public void start(){
		String ids = getPara("ids");
		if(EStr.notEmpty(ids)){
			String[] arr = ids.split(",");
			Arrays.stream(arr).forEach(id -> {
				DataBase db = dbs.getDataBase(id);
				dbs.startDataBase(db.getCode());
			});
		}
		redirect(attr().getCtrl());
	}
	
	public void stop(){
		String ids = getPara("ids");
		if(EStr.notEmpty(ids)){
			String[] arr = ids.split(",");
			Arrays.stream(arr).forEach(id -> {
				DataBase db = dbs.getDataBase(id);
				dbs.stopDataBase(db.getCode());
			});
		}
		redirect(attr().getCtrl());
	}
	
	public void add(){
		User user = (User) session().getUser();
		DataBase obj = getBean(DataBase.class, "");
		if(obj.getCode().equals("main")){
			setFlashMsg("数据库别名不允许使用“main”，请修改！");
			redirect(attr().getCtrl());
			return;
		}else{
			DataBase objExist = dbs.getDataBaseByCode(obj.getCode());
			if(objExist != null){
				setFlashMsg("数据库别名[" + obj.getCode() + "]已存在，请修改！");
				redirect(attr().getCtrl());
				return;
			}
		}
		Vert vert = user.getVert();
		obj.setOwnerCompId(attr().getComp().getId());
		obj.setOwnerCompName(attr().getComp().getCaption());
		obj.setOwnerDeptId(user.getDeptId());
		obj.setOwnerDeptName(user.getDept().getCaption());
		obj.setOwnerVertId(vert == null ? null : vert.getId());
		obj.setOwnerVertName(vert == null ? null : vert.getCaption());
		obj.setOwnerUserId(user.getId());
		obj.setOwnerUserName(user.getCaption());
		dbs.save(obj);
		redirect(attr().getCtrl());
	}
	
	public void modify(){
		DataBase obj = getBean(DataBase.class, "");
		if(EStr.isEmpty(obj.getDbPassWord())){
			obj.keep("id", "code", "caption", "summary", "dbType", "dbDriverClass", "dbUrl", "dbUserName", "dbInitialSize", "dbMinIdle", "dbMaxActive", "autoRun", "allowCreateTable", "accessLevel");
		}
		DataBase objOld = dbs.findById(obj.getId());
		objOld._setAttrs(obj);
		dbs.update(objOld);
		redirect(attr().getCtrl());
	}
	
	public void remove(){
		String ids = getPara("ids");
		dbs.remove(ids);
		redirect(attr().getCtrl());
	}
	
}
