package itez.plat.source;

import itez.core.runtime.modules.ModuleBase;

/**
 * 模块配置类，用于系统启动时自动进行模块注册
 * 
 * @author netwild
 *
 */
public class ModuleConfig extends ModuleBase {
	
	public static final String MODULE_CODE = "source";

	private String moduleCode = MODULE_CODE;
	private String modulePath = "/" + MODULE_CODE;
	private String moduleView = MODULE_CODE;
	private String moduleName = "数据源";

	public final static String SERVICE_SOURCE = "sourceService";
	public final static String SERVICE_SOURCE_DATA_BASE = "sourceDataBaseService";
	public final static String SERVICE_SOURCE_DATA_TABLE = "sourceDataTableService";
	public final static String SERVICE_SOURCE_DATA_SET = "sourceDataSetService";
	
	@Override
	public String getModuleCode() {
		return moduleCode;
	}
	
	@Override
	public String getModulePath() {
		return modulePath;
	}

	@Override
	public String getModuleView() {
		return moduleView;
	}

	@Override
	public String getModuleName() {
		return moduleName;
	}

	@Override
	public void setModulePath(String modulePath) {
		this.modulePath = modulePath;
	}

	@Override
	public void setModuleView(String moduleView) {
		this.moduleView = moduleView;
	}

}
