package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.runtime.EContext;
import itez.core.runtime.modules.ModuleManager;
import itez.core.runtime.service.Define;
import itez.plat.site.ModuleConfig;
import itez.plat.site.model.Info;
import itez.plat.site.service.InfoService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class InfoServiceImpl extends EModelService<Info> implements InfoService {

	@Override
	public Info createInfo(){
		Info info = new Info();
		info.setIndex(EContext.getAttr().getSrc() + ModuleManager.me.getModule(ModuleConfig.MODULE_CODE).getModulePath());
		info.setCaption(EContext.getAttr().getComp().getCaption());
		info.setSubCaption("");
		info.setWelcome("欢迎访问网站首页！");
		super.save(info);
		return info;
	}

	@Override
	public Info getInfo(){
		return getInfo(null);
	}

	@Override
	public Info getInfo(String subDomain) {
		Querys qs = null;
		if(subDomain != null) qs = Querys.and(Query.eq("subDomain", subDomain));
		else qs = Querys.and(Query.nu("subDomain"));
		Info info = selectFirst(qs);
		if(info == null && subDomain == null) info = createInfo();
		return info;
	}

	@Override
	public List<Info> getSubs() {
		Querys qs = Querys.and(Query.nn("subDomain"));
		return select(qs);
	}

	@Override
	public List<Info> getInfos() {
		return select(null, "subDomain, id");
	}

	@Override
	public Info modifyInfo(Info info){
		super.update(info);
		return info;
	}

}