package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EStr;
import itez.core.runtime.service.Define;
import itez.plat.site.model.Content;
import itez.plat.site.service.ContentService;

import java.util.Date;
import java.util.List;

import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ContentServiceImpl extends EModelService<Content> implements ContentService {

	@Override
	public List<Content> getByChannelId(String channelId){
		return getByChannelId(channelId, null);
	}

	@Override
	public List<Content> getByChannelId(String channelId, Integer limit){
		return getByChannelId(channelId, limit, true);
	}

	@Override
	public List<Content> getByChannelId(String channelId, Integer limit, Boolean desc){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		Selector selector = Selector.select().where(qs).orderBy(getOrderBy(desc)).setLimit(limit);
		return select(selector);
	}

	@Override
	public List<Content> getByChannelIds(List<String> channelIds, Integer limit, Boolean desc){
		String[] ids = channelIds.toArray(new String[channelIds.size()]);
		Querys qs = Querys.and(Query.in("channelId", EStr.ida2sqlIn(ids)));
		Selector selector = Selector.select().where(qs).orderBy(getOrderBy(desc)).setLimit(limit);
		return select(selector);
	}

	@Override
	public Page<Content> getPageByChannelId(String channelId, Integer pageNum, Integer pageSize, Boolean desc){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		Selector selector = Selector.select().where(qs).orderBy(getOrderBy(desc));
		return paginate(pageNum, pageSize, selector);
	}

	@Override
	public Page<Content> getPageByChannelIds(List<String> channelIds, Integer pageNum, Integer pageSize, Boolean desc){
		String[] ids = channelIds.toArray(new String[channelIds.size()]);
		Querys qs = Querys.and(Query.in("channelId", EStr.ida2sqlIn(ids)));
		Selector selector = Selector.select().where(qs).orderBy(getOrderBy(desc));
		return paginate(pageNum, pageSize, selector);
	}

	@Override
	public List<Content> searchByChannelId(String channelId, String keyword, Boolean desc){
		Querys qs = Querys.and(Query.eq("channelId", channelId)).add(Query.like("caption", "%" + keyword + "%"));
		Selector selector = Selector.select().where(qs).orderBy(getOrderBy(desc));
		return select(selector);
	}

	@Override
	public List<Content> searchByChannelIds(List<String> channelIds, String keyword, Boolean desc){
		String[] ids = channelIds.toArray(new String[channelIds.size()]);
		Querys qs = Querys.and(Query.in("channelId", EStr.ida2sqlIn(ids))).add(Query.like("caption", "%" + keyword + "%"));;
		Selector selector = Selector.select().where(qs).orderBy(getOrderBy(desc));
		return select(selector);
	}

	@Override
	public Content first(String channelId){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		return selectFirst(qs, getOrderBy(false));
	}

	@Override
	public Content last(String channelId){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		return selectFirst(qs, getOrderBy(true));
	}

	@Override
	public Content next(String channelId, Integer sort, Date mdate){
		Querys q1 = Querys.or(Query.gt("sort", sort)).add(Query.gt("mdate", mdate));
		Querys qs = Querys.and(Query.eq("channelId", channelId)).add(q1);
		return selectFirst(qs, getOrderBy(false));
	}

	@Override
	public Content previous(String channelId, Integer sort, Date mdate){
		Querys q1 = Querys.or(Query.lt("sort", sort)).add(Query.lt("mdate", mdate));
		Querys qs = Querys.and(Query.eq("channelId", channelId)).add(q1);
		return selectFirst(qs, getOrderBy(true));
	}
	
	private String getOrderBy(Boolean desc){
		if(desc == null) desc = false;
		StringBuilder ord = new StringBuilder();
		ord.append("sort");
		if(desc) ord.append(" desc");
		ord.append(", mdate");
		if(desc) ord.append(" desc");
		return ord.toString();
	}

	@Override
	public void removeByChannels(String channelIds) {
		String sql = String.format("delete from site_content where channelId in (%s)", EStr.ids2sqlIn(channelIds));
		dbo().delete(sql);
	}

	@Override
	public List<Record> getBetweenYears(String domain, Integer yearf, Integer yeare) {
		Kv params = Kv.by("domain", domain).set("yearFrom", yearf).set("yearEnd", yeare);
		SqlPara sql = dbo().getSqlPara("site.Get_Content_Between_Years", params);
		return dbo().find(sql);
	}

	@Override
	public void removeBetweenYears(String domain, Integer yearf, Integer yeare){
		Kv params = Kv.by("domain", domain).set("yearFrom", yearf).set("yearEnd", yeare);
		SqlPara sql = dbo().getSqlPara("site.Remove_Content_Between_Years", params);
		dbo().update(sql);
	}

}