package itez.plat.site.service.impl;

import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EStr;
import itez.core.runtime.service.Define;
import itez.plat.site.ModuleConfig;
import itez.plat.site.model.Channel;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.NaviItemService;
import itez.plat.wrapper.service.ETreeService;

import java.util.List;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ChannelServiceImpl extends ETreeService<Channel> implements ChannelService {

	@Inject
	ContentService contentSer;
	
	@Inject
	NaviItemService naviItemSer;

	@Override
	public Channel findByCode(String subDomain, String code) {
		Querys qs = Querys.and(Query.eq("code", code)).add(Query.eq("subDomain", subDomain));
		return selectFirst(qs);
	}

	@Override
	public Channel createIndexChannel(String subDomain) {
		if(subDomain == null) subDomain = "";
		Channel channel = new Channel();
		channel.setSubDomain(subDomain);
		channel.setCode(ModuleConfig.INDEX_CODE);
		channel.setIcon("fa fa-home");
		channel.setPic("");
		channel.setCaption("网站首页");
		channel.setContent("");
		channel.setPath("001");
		channel.setSort(1);
		channel.setChannelTemp("index.html");
		channel.setContentTemp("content.html");
		super.save(channel);
		return channel;
	}

	@Override
	public Channel getIndexChannel(String subDomain) {
		if(subDomain == null) subDomain = "";
		Querys qs = Querys.and(Query.eq("code", ModuleConfig.INDEX_CODE)).add(Query.eq("subDomain", subDomain));
		Channel channel = selectFirst(qs);
		if(channel == null) channel = createIndexChannel(subDomain);
		return channel;
	}

	@Override
	public List<Channel> getAllChannels(String subDomain) {
		Querys qs = Querys.and(Query.nn("pid")).add(Query.eq("subDomain", subDomain));
		return select(qs, "path");
	}

	@Override
	public List<Record> getBackChannels(String domain, String subDomain) {
		Kv paras = Kv.by("domain", domain).set("subDomain", subDomain);
		SqlPara sql = dbo().getSqlPara("site.Backup_Channel", paras);
		return dbo().find(sql);
	}

	@Override
	public void removeAllChannels(String domain, String subDomain) {
		Kv paras = Kv.by("domain", domain).set("subDomain", subDomain);
		SqlPara sql = dbo().getSqlPara("site.Restore_Channel", paras);
		dbo().update(sql);
	}

	@Override
	public List<Channel> getTreeChannels(String subDomain) {
		Querys qs = Querys.and(Query.nn("pid")).add(Query.eq("subDomain", subDomain));
		Selector selector = Selector.select("id, pid, code, icon, pic, caption, subCaption, path").where(qs).orderBy("path");
		return select(selector);
	}

	@Override
	public void addChannel(Channel channel){
		super.save(channel);
	}

	@Override
	public void modifyChannel(Channel channel){
		super.update(channel);
	}

	@Override
	public void removeChannels(String subDomain, String ids){
		List<String> subIds = getChildrenIds(subDomain, ids);
		subIds.add(ids);
		String idAndSubs = EStr.parseArray(subIds);
		contentSer.removeByChannels(idAndSubs);
		naviItemSer.removeByChannels(idAndSubs);
		super.deleteByIds(idAndSubs);
	}

	@Override
	public Channel getLastChannel(String subDomain, String pid) {
		Querys qs = Querys.and(Query.eq("subDomain", subDomain));
		return super.getLast(qs, pid);
	}

	@Override
	public void sort(String subDomain, String pid, String opt, String ids) {
		Querys qs = Querys.and(Query.eq("subDomain", subDomain));
		super.sort(qs, pid, opt, ids);
	}

	@Override
	public List<Channel> getChildren(String id){
		Querys qs = Querys.and(Query.eq("pid", id));
		return select(qs, "sort", null);
	}

	@Override
	public List<String> getChildrenIds(String subDomain, String id) {
		Channel parent = findById(id);
		Querys qs = Querys.and(Query.like("path", parent.getPath() + "%")).add(Query.eq("subDomain", subDomain));
		return selectCol(qs, "id");
	}
	
}