package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EDate;
import itez.kit.EFile;
import itez.kit.EJson;
import itez.kit.EProp;
import itez.kit.ERegex;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.zip.ZipKit;
import itez.core.runtime.service.Define;
import itez.plat.site.model.BackupHis;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.model.Info;
import itez.plat.site.model.Navi;
import itez.plat.site.model.NaviItem;
import itez.plat.site.service.BackupHisService;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.InfoService;
import itez.plat.site.service.NaviItemService;
import itez.plat.site.service.NaviService;
import itez.plat.site.service.SiteTempService;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.activerecord.Record;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class BackupHisServiceImpl extends EModelService<BackupHis> implements BackupHisService {

	@Inject
	SiteTempService tempSer;
	
	@Inject
	InfoService infoSer;
	
	@Inject
	ChannelService chnSer;
	
	@Inject
	NaviService naviSer;
	
	@Inject
	NaviItemService naviItemSer;
	
	@Inject
	ContentService contentSer;
	
	private List<Record> backType = Lists.newArrayList();
	String FileSep = File.separator;
	private String backRootPath = "";
	private String backRootUrl = "";
	
	public BackupHisServiceImpl(){
		backType.add(new Record().set("key", "temp").set("value", "模板、资源"));
		backType.add(new Record().set("key", "site").set("value", "模板、资源、网站配置"));
		backType.add(new Record().set("key", "content").set("value", "模板、资源、网站配置、文章"));
		//backType.add(new Record().set("key", "all").set("value", "全部"));		//暂时不开放整站备份
		
		backRootPath = EProp.LocalFilePath;
    	if(!backRootPath.startsWith("/") && !backRootPath.startsWith("\\") && !ERegex.has(backRootPath, "^[A-Za-z]\\:")){
    		backRootPath = PathKit.getWebRootPath() + FileSep + backRootPath;
    	}
		if(!backRootPath.endsWith(FileSep)){
			backRootPath += FileSep;
		}
		backRootUrl = EProp.LocalFileUrl;
		if(!backRootUrl.endsWith("/")){
			backRootUrl += "/";
		}
	}

	@Override
	public List<Record> getBackTypes() {
		return backType;
	}

	@Override
	public List<BackupHis> getBackHis(String type) {
		Querys qs = Querys.and();
		if(EStr.notEmpty(type)) qs.add(Query.eq("btype", type));
		return select(qs, "cdate desc");
	}

	@Override
	public BackupHis getByBakName(String bakName) {
		Querys qs = Querys.and(Query.eq("bakName", bakName));
		return selectFirst(qs);
	}

	@Override
	public void create(BackupHis bak) {
		save(bak);
		String domain = $domain();
		new Thread(new Runnable() {
			@Override
			public void run() {
				createEvent(bak, domain);
			}
		}).start();
	}
	
	private void createEvent(BackupHis bak, String domain){
		String bakName = formatPath(bak);
		try {
			backup_file(domain, bak, bakName);
			backup_temp(domain, bakName);
			backup_res(domain, bakName);
			if(!bak.getBtype().equals("temp")) backup_site(domain, bakName);
			if(bak.getBtype().equals("content")) backup_content(domain, bakName, bak.getDfrom(), bak.getDend());
			if(bak.getBtype().equals("all")) backup_content(domain, bakName, null, null);
			update(bak.setState(1).setBakName(bakName));
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}
	
	private void backup_file(String domain, BackupHis bak, String bakName) throws IOException{
		File bakFile = new File(getBackHisPath(bakName, domain).concat("/backup.bak"));
		bakFile.createNewFile();
		EFile.write(bakFile, EJson.toJson(bak));
	}
	
	private void backup_temp(String domain, String bakName) throws IOException{
		String tempRoot = tempSer.getRootPath(domain, null);
		File tempFile = new File(tempRoot);
		if(!tempFile.exists()) return;
		String tempBakRoot = getBackHisPath(bakName, domain).concat(FileSep).concat("temp");
		EFile.copyDir(tempFile, new File(tempBakRoot));
	}
	
	private void backup_res(String domain, String bakName) throws IOException{
		String resRoot = backRootPath.concat(domain).concat(FileSep).concat("res");
		File resFile = new File(resRoot);
		if(!resFile.exists()) return;
		String resBakRoot = getBackHisPath(bakName, domain).concat(FileSep).concat("res");
		EFile.copyDir(resFile, new File(resBakRoot));
	}
	
	private void backup_site(String domain, String bakName) throws IOException{
		Info info = infoSer.getInfo();
		List<Record> channels = chnSer.getBackChannels(domain, "");
		List<Record> navis = naviSer.getBackNavis(domain, "");
		List<Record> naviItems = naviItemSer.getBackNavis(domain, "");
		String sitePath = getBackHisPath(bakName, domain).concat(FileSep).concat("site");
		File toPath = new File(sitePath);
		if(!toPath.exists()) toPath.mkdirs();
		File infoFile = new File(sitePath.concat("/info.bak"));
		File channelsFile = new File(sitePath.concat("/channels.bak"));
		File navisFile = new File(sitePath.concat("/navis.bak"));
		File naviItemsFile = new File(sitePath.concat("/naviItems.bak"));
		infoFile.createNewFile();
		channelsFile.createNewFile();
		navisFile.createNewFile();
		naviItemsFile.createNewFile();
		EFile.write(infoFile, EJson.toJson(info));
		EFile.write(channelsFile, EJson.toJson(channels));
		EFile.write(navisFile, EJson.toJson(navis));
		EFile.write(naviItemsFile, EJson.toJson(naviItems));
	}
	
	private void backup_content(String domain, String bakName, String dfrom, String dend) throws IOException{
		Integer yearFrom = null;
		if(EStr.notEmpty(dfrom)) yearFrom = Integer.parseInt(dfrom);
		Integer yearEnd = null;
		if(EStr.notEmpty(dend)) yearEnd = Integer.parseInt(dend);
		List<Record> list = contentSer.getBetweenYears(domain, yearFrom, yearEnd);
		String sitePath = getBackHisPath(bakName, domain).concat(FileSep).concat("site");
		File toPath = new File(sitePath);
		if(!toPath.exists()) toPath.mkdirs();
		File contentFile = new File(sitePath.concat("/content.bak"));
		contentFile.createNewFile();
		EFile.write(contentFile, EJson.toJson(list));
	}
	
	private String formatPath(BackupHis bak){
		return bak.getBtype().concat(EDate.format(bak.getCdate(), "yyyyMMddHHmmss"));
	}
	
	private String getBackPath(String domain){
		return backRootPath.concat(domain).concat("/bak");
	}
	
	private String getBackHisPath(String bakName){
		return getBackHisPath(bakName, $domain());
	}
	
	private String getBackHisPath(String bakName, String domain){
		String hisPath = getBackPath(domain).concat(FileSep).concat(bakName);
		File toPath = new File(hisPath);
		if(!toPath.exists()) toPath.mkdirs();
		return hisPath;
	}

	@Override
	public void removeBak(String ids) {
		 List<BackupHis> baks = findByIds(ids);
		 baks.forEach(bak -> removeBakItem(bak));
	}
	
	private void removeBakItem(BackupHis bak){
		String bakName = formatPath(bak);
		String bakPath = getBackHisPath(bakName);
		String zipPath = bakPath.concat(".zip");
		File zipFile = new File(zipPath);
		if(zipFile.exists()) zipFile.delete();
		EFile.deleteDir(bakPath);
		deleteById(bak.getId());
	}

	@Override
	public File download(String id) {
		BackupHis bak = findById(id);
		String bakName = formatPath(bak);
		String bakPath = getBackHisPath(bakName);
		String zipPath = bakPath.concat(".zip");
		File zipFile = new File(zipPath);
		if(zipFile.exists()) return zipFile;
		zipPath = ZipKit.me.zip(bakPath, null);
		zipFile = new File(zipPath);
		return zipFile;
	}

	@Override
	public void upload(File file) throws IOException {
		String parentPath = file.getParent();
		String fileNameAll = file.getName();
		String fileName = fileNameAll.split("\\.")[0];
		EFile.unzip(file.getPath());
		File parentDir = new File(parentPath.concat(FileSep).concat(fileName));
		File[] files = parentDir.listFiles();
		if(files == null || files.length > 1) throw new RuntimeException("备份文件结构错误！");
		
		File bakDir = files[0];
		String bakDirStr = bakDir.getPath().concat(FileSep);
		
		File bakFile = new File(bakDirStr.concat("backup.bak"));
		if(!bakFile.exists()) throw new RuntimeException("未发现备份描述文件！");
		String bakJson = EFile.read(bakFile);
		BackupHis bak = JSON.parseObject(bakJson, BackupHis.class);
		
		BackupHis bakExist = getByBakName(bak.getBakName());
		if(bakExist != null) throw new RuntimeException("备份文件已经存在，请不要重复上传！");
		
		bak.setDomain($domain()).setState(1).setId(EUid.generator());

		String bakName = formatPath(bak);
		String bakDirName = bakDir.getName();
		if(!bakName.equals(bakDirName)) throw new RuntimeException("备份文件夹名称错误！");
		
		String bakPath = getBackHisPath(bakName);
		EFile.copyDir(bakDir, new File(bakPath));
		EFile.deleteDir(bakDir.getPath());
		
		save(bak);
	}

	@Override
	public void restore(String id) {
		BackupHis bak = findById(id);
		update(bak.setState(0));
		String domain = $domain();
		new Thread(new Runnable() {
			@Override
			public void run() {
				restoreEvent(bak, domain);
			}
		}).start();
	}
	
	public void restoreEvent(BackupHis bak, String domain){
		String bakName = formatPath(bak);
		try {
			restore_temp(domain, bak, bakName);
			restore_res(domain, bak, bakName);
			if(!bak.getBtype().equals("temp")) restore_site(domain, bak, bakName, bak.getDfrom(), bak.getDend());
			update(bak.setState(1));
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}
	
	private void restore_temp(String domain, BackupHis bak, String bakName) throws IOException{
		String tempRoot = tempSer.getRootPath(domain, null);
		File tempFile = new File(tempRoot);
		if(tempFile.exists()) EFile.deleteDir(tempRoot);
		String tempBakRoot = getBackHisPath(bakName, domain).concat(FileSep).concat("temp");
		EFile.copyDir(new File(tempBakRoot), new File(tempRoot));
	}
	
	private void restore_res(String domain, BackupHis bak, String bakName) throws IOException{
		String resRoot = backRootPath.concat(domain).concat(FileSep).concat("res");
		File resFile = new File(resRoot);
		if(resFile.exists()) EFile.deleteDir(resRoot);
		String resBakRoot = getBackHisPath(bakName, domain).concat(FileSep).concat("res");
		EFile.copyDir(new File(resBakRoot), new File(resRoot));
	}
	
	private void restore_site(String domain, BackupHis bak, String bakName, String dfrom, String dend){
		String sitePath = getBackHisPath(bakName, domain).concat(FileSep).concat("site");
		File toPath = new File(sitePath);
		if(!toPath.exists()) return;
		File infoFile = new File(sitePath.concat("/info.bak"));
		File channelsFile = new File(sitePath.concat("/channels.bak"));
		File navisFile = new File(sitePath.concat("/navis.bak"));
		File naviItemsFile = new File(sitePath.concat("/naviItems.bak"));
		File contentsFile = new File(sitePath.concat("/content.bak"));
		
		if(infoFile.exists()){
			String infoStr = EFile.read(infoFile);
			Info info = JSON.parseObject(infoStr, Info.class);
			info.remove("id", "domain", "cdate", "mdate", "used");
			Info infoExist = infoSer.getInfo();
			infoExist._setAttrs(info);
			infoSer.update(infoExist);
		}

		Map<String, String> channelIdCache = Maps.newHashMap();
		if(channelsFile.exists()){
			String channelsStr = EFile.read(channelsFile);
			List<Channel> channels = JSON.parseArray(channelsStr, Channel.class);
			channels.forEach(channel -> {
				String oldId = channel.getId();
				String oldPid = channel.getPid();
				String newId, newPid;
				if(channelIdCache.containsKey(oldId)){
					newId = channelIdCache.get(oldId);
				}else{
					newId = EUid.generator();
					channelIdCache.put(oldId, newId);
				}
				if(oldPid == null){
					newPid = null;
				}else if(channelIdCache.containsKey(oldPid)){
					newPid = channelIdCache.get(oldPid);
				}else{
					newPid = EUid.generator();
					channelIdCache.put(oldPid, newPid);
				}
				channel.setId(newId).setPid(newPid).setDomain(domain);
			});
			if(channels.size() > 0){
				chnSer.removeAllChannels(domain, "");
				dbo().batchSave(channels, channels.size());
			}
		}

		Map<String, String> naviIdCache = Maps.newHashMap();
		if(navisFile.exists()){
			String navisStr = EFile.read(navisFile);
			List<Navi> navis = JSON.parseArray(navisStr, Navi.class);
			navis.forEach(navi -> {
				String oldId = navi.getId();
				String newId = EUid.generator();
				naviIdCache.put(oldId, newId);
				navi.setId(newId).setDomain(domain);
			});
			if(navis.size() > 0){
				naviSer.removeAllNavis(domain, "");
				dbo().batchSave(navis, navis.size());
			}
		}
		
		if(naviItemsFile.exists()){
			String naviItemsStr = EFile.read(naviItemsFile);
			List<NaviItem> naviItems = JSON.parseArray(naviItemsStr, NaviItem.class);
			naviItems.forEach(navi -> {
				String naviId = naviIdCache.get(navi.getNaviId());
				String channelId = channelIdCache.get(navi.getChannelId());
				if(channelId == null) channelId = "-";
				navi.setId(EUid.generator()).setDomain(domain).setNaviId(naviId).setChannelId(channelId);
			});
			if(naviItems.size() > 0){
				naviItemSer.removeAllNavis(domain, "");
				dbo().batchSave(naviItems, naviItems.size());
			}
		}
		
		if(contentsFile.exists()){
			String contentsStr = EFile.read(contentsFile);
			List<Content> contents = JSON.parseArray(contentsStr, Content.class);
			contents.forEach(content -> {
				String channelId = channelIdCache.get(content.getChannelId());
				content.setId(EUid.generator()).setDomain(domain).setChannelId(channelId);
			});
			if(contents.size() > 0){
				Integer yearFrom = null, yearEnd = null;
				if(EStr.notEmpty(dfrom)) yearFrom = Integer.parseInt(dfrom);
				if(EStr.notEmpty(dend)) yearEnd = Integer.parseInt(dend);
				contentSer.removeBetweenYears(domain, yearFrom, yearEnd);
				dbo().batchSave(contents, contents.size());
			}
		}
	}

}