package itez.plat.site.model;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.kit.EStr;
import itez.plat.site.ModuleConfig;
import itez.plat.site.model.base.BaseContent;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class Content extends BaseContent<Content> {
	
	private final static ChannelService channelSer = Ioc.get(ChannelService.class);
	private final static ContentService contentSer = Ioc.get(ContentService.class);
	
	public String url(){
		if(EStr.isEmpty(getId())) return EContext.getAttr().getSrc();
		if(EStr.notEmpty(getLink())) return getLink();
		if(EStr.isEmpty(getSubDomain()))
			return String.format("%s/%s/%s", EContext.getAttr().getSrc(), ModuleConfig.CONTENT_ACTION, getId());
		else
			return String.format("%s/sub/%s/%s-%s", EContext.getAttr().getSrc(), ModuleConfig.CONTENT_ACTION, getSubDomain(), getId());
	}
	
	public Content by(String id){
		return contentSer.findById(id);
	}
	
	public Content next(){
		if(EStr.isEmpty(getId())) return null;
		return contentSer.next(getChannelId(), getSort(), getMdate());
	}
	
	public Content previous(){
		if(EStr.isEmpty(getId())) return null;
		return contentSer.previous(getChannelId(), getSort(), getMdate());
	}
	
	public Channel channel(){
		if(EStr.isEmpty(getChannelId())) return null;
		return channelSer.findById(getChannelId());
	}
	
}
