package itez.plat.site.controller;

import itez.core.runtime.EContext;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.site.ModuleConfig;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.model.Info;

@ControllerDefine(key = "/sub", summary = "子站", view = "/")
public class SubController extends SiteController {
	
	public void index(){
		String subDomain = getPara(0);
		if(EStr.isEmpty(subDomain)){
			renderText("未知子站！");
			return;
		}
		Info site = infoSer.getInfo(subDomain);
		if(site == null){
			renderText("子站不存在！");
			return;
		}
		Channel channel = channelSer.getIndexChannel(subDomain);
		String view = channel.getChannelTemp();
		if(!tempSer.checkTemp(subDomain, view)){
			renderEmptySite();
			return;
		}
		renderSite(Type.INDEX, site, channel, new Content(), subDomain, view);
	}
	
	public void channel(){
		String code = getPara(1);
		if(EStr.isEmpty(code)){
			renderText("未知栏目！");
			return;
		}
		String subDomain = getPara(0);
		if(EStr.isEmpty(subDomain)){
			renderText("未知子站！");
			return;
		}
		Info site = infoSer.getInfo(subDomain);
		if(site == null){
			renderText("子站不存在！");
			return;
		}
		Channel channel = channelSer.findByCode(subDomain, code);
		if(null == channel){
			renderText("栏目不存在！");
			return;
		}
		String view = channel.getChannelTemp();
		if(!tempSer.checkTemp(subDomain, view)){
			renderEmptySite();
			return;
		}
		renderSite(Type.CHANNEL, site, channel, new Content(), subDomain, view);
	}
	
	public void content(){
		String id = getPara(1);
		if(EStr.isEmpty(id)){
			renderText("未知文章！");
			return;
		}
		Content content = contentSer.findById(id);
		if(null == content){
			renderText("文章不存在！");
			return;
		}
		String subDomain = getPara(0, content.getSubDomain());
		if(EStr.isEmpty(subDomain)){
			String url = String.format("%s/%s/%s", EContext.getAttr().getSrc(), ModuleConfig.CONTENT_ACTION, id);
			redirect(url);
			return;
		}
		Info site = infoSer.getInfo(subDomain);
		if(site == null){
			renderText("子站不存在！");
			return;
		}
		Channel channel = channelSer.findById(content.getChannelId());
		if(null == channel){
			renderText("栏目不存在！");
			return;
		}
		String view = channel.getContentTemp();
		if(!tempSer.checkTemp(subDomain, view)){
			renderEmptySite();
			return;
		}
		renderSite(Type.CONTENT, site, channel, content, subDomain, view);
	}
	
}
