package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.core.NotAction;
import com.jfinal.template.Engine;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EControllerSite;
import itez.kit.ELog;
import itez.kit.EStr;
import itez.plat.site.bean.SiteTemp;
import itez.plat.site.model.Info;
import itez.plat.site.service.InfoService;
import itez.plat.site.service.SiteTempService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/temp", summary = "网站模板", view = "/")
public class SiteTempController extends EControllerMgr {

	@Inject
	InfoService infoSer;

	@Inject
	SiteTempService tempSer;
	
	public void index(String subDomain){
		if(EStr.isNull(subDomain)) subDomain = "";
		List<SiteTemp> temps = tempSer.getTemps(subDomain);
		List<Info> sites = infoSer.getInfos();
		setAttr("temps", temps);
		setAttr("subDomain", subDomain);
		setAttr("sites", sites);
		render("temp.html");
	}
	
	public void init(String subDomain){
		if(EStr.isNull(subDomain)) subDomain = "";
		tempSer.init(subDomain);
		setFlashMsg("标准模板初始化完成！");
		redirect(attr().getCtrl().concat("?subDomain=").concat(subDomain));
	}
	
	public void del(String subDomain, String fileName){
		if(EStr.isNull(subDomain)) subDomain = "";
		boolean does = tempSer.del(subDomain, fileName);
		if(!does) setFlashMsg("删除失败！");
		else clearTemp(fileName);
		redirect(attr().getCtrl().concat("?subDomain=").concat(subDomain));
	}
	
	public void saveas(String subDomain, String f, String t){
		if(EStr.isNull(subDomain)) subDomain = "";
		tempSer.saveas(subDomain, f, t);
		redirect(attr().getCtrl().concat("?subDomain=").concat(subDomain));
	}
	
	public void edit(String subDomain, String fileName){
		if(EStr.isNull(subDomain)) subDomain = "";
		String act;
		SiteTemp temp;
		if(EStr.isEmpty(fileName)){
			act = "create";
			temp = new SiteTemp();
			temp.setFileName("new.html");
			temp.setSpace(0L);
			temp.setContent("<html></html>");
		}else{
			act = "modify";
			temp = tempSer.getTemp(subDomain, fileName);
		}
		setAttr("act", act);
		setAttr("temp", temp);
		setAttr("subDomain", subDomain);
		render("tempContent.html");
	}
	
	public void editDo(String subDomain, String act, String fileName, String content){
		if(EStr.isNull(subDomain)) subDomain = "";
		SiteTemp temp = new SiteTemp();
		temp.setFileName(fileName);
		temp.setContent(content);
		if(act.equals("create")){
			tempSer.create(subDomain, temp);
		}else if(act.equals("modify")){
			tempSer.modify(subDomain, temp);
		}
		clearTemp(subDomain, fileName);
		redirect(attr().getCtrl().concat("?subDomain=").concat(subDomain));
	}
	
	public void clear(String subDomain){
		if(EStr.isNull(subDomain)) subDomain = "";
		String[] views = new String[]{"index.html", "channel.html", "content.html"};
		clearTemp(subDomain, views);
		setFlashMsg("网站模板缓存清理完成！");
		redirect(attr().getCtrl().concat("?subDomain=").concat(subDomain));
	}
	
	@NotAction
	private void clearTemp(String subDomain, String...views){
		if(EStr.isNull(subDomain)) subDomain = "";
		if(views == null || views.length == 0) return;
		Engine engine = EControllerSite.getEngine();
		if(engine == null) return;
		String path = "/".concat(attr().getDomain());
		if(subDomain != null) path = path.concat("/").concat(subDomain);
		for(String view : views){
			String viewPath = path.concat(view);
			try {
				engine.removeTemplateCache(viewPath);
				ELog.info("网站模板缓存清理成功：{}", viewPath);
			} catch (Exception e) {
				ELog.error("网站模板缓存清理失败，模板文件不存在：{}", viewPath);
			}
		}
	}
	
}
