package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.site.model.Info;
import itez.plat.site.service.InfoService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/site/sub", summary = "子站管理", view = "/")
public class SiteSubController extends EControllerMgr {

	@Inject
	InfoService infoSer;
	
	public void index(){
		List<Info> subs = infoSer.getSubs();
		setAttr("subs", EJson.toJsonFilter(subs, "id", "subDomain", "caption"));
		render("subs.html");
	}
	
	public void form(String id){
		Info info = EStr.isEmpty(id) ? new Info() : infoSer.findById(id);
		setAttr("model", EJson.toJson(info));
		render("subsForm.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		Info info = paras.getModel(Info.class);
		if(EStr.isEmpty(info.getId())) infoSer.save(info);
		else infoSer.update(info);
		redirect(attr().getCtrl());
	}
	
	public void remove(String id){
		infoSer.disableByIds(id);
		redirect(attr().getCtrl());
	}
	
}
