package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.site.model.Info;
import itez.plat.site.model.Navi;
import itez.plat.site.service.InfoService;
import itez.plat.site.service.NaviService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/navi", summary = "网站导航", view = "/")
public class SiteNaviController extends EControllerMgr {

	@Inject
	InfoService infoSer;
	
	@Inject
	NaviService naviSer;

	public void index(String subDomain){
		if(EStr.isNull(subDomain)) subDomain = "";
		List<Navi> navis = naviSer.getNavis(subDomain);
		List<Info> sites = infoSer.getInfos();
		setAttr("navis", navis);
		setAttr("subDomain", subDomain);
		setAttr("sites", sites);
		render("navi.html");
	}
	
	public void addNavi(){
		Navi navi = getBean(Navi.class, "");
		if(navi.getSubDomain() == null) navi.setSubDomain("");
		naviSer.save(navi);
		redirect(attr().getCtrl() + "?subDomain=" + navi.getSubDomain());
	}
	
	public void modifyNavi(){
		Navi naviNew = getBean(Navi.class, "");
		Navi navi = naviSer.findById(naviNew.getId());
		if(naviNew.getSubDomain() == null) naviNew.setSubDomain("");
		navi._setAttrs(naviNew);
		naviSer.update(navi);
		redirect(attr().getCtrl() + "?subDomain=" + navi.getSubDomain());
	}
	
	public void removeNavi(String subDomain, String ids){
		if(EStr.isNull(subDomain)) subDomain = "";
		naviSer.deleteByIds(ids);
		redirect(attr().getCtrl() + "?subDomain=" + subDomain);
	}
	
}
