package itez.plat.site.controller;

import com.google.inject.Inject;

import itez.core.wrapper.controller.EControllerSite;
import itez.plat.main.model.Countor;
import itez.plat.main.service.CountorService;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.model.Info;
import itez.plat.site.model.Navi;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.InfoService;
import itez.plat.site.service.SiteTempService;

public abstract class SiteController extends EControllerSite {

	protected static enum Type { INDEX, CHANNEL, CONTENT }
	
	@Inject
	protected InfoService infoSer;
	
	@Inject
	protected ChannelService channelSer;
	
	@Inject
	protected ContentService contentSer;
	
	@Inject
	protected SiteTempService tempSer;

	@Inject
	protected CountorService countorSer;
	
	/**
	 * 空白页面
	 */
	protected void renderEmptySite(){
		String ch = "抱歉！当前网站还未设置相关模板，无法显示页面。<br><br>如果您是网站管理员，请登录网站后台进行网站模板初始化操作。";
		String en = "I'm sorry! No template has been set up on the current website, so the page can not be displayed.<br><br>If you are a webmaster, please go to the back of the website to initialize the website template.";
		renderHtml(ch.concat("<br><br><hr><br>").concat(en));
	}

	/**
	 * 渲染到指定页面
	 * 
	 * @param type
	 * @param site
	 * @param channel
	 * @param content
	 * @param subDomain
	 * @param view
	 */
	protected void renderSite(Type type, Info site, Channel channel, Content content, String subDomain, String view){
		Navi navi = new Navi().setSubDomain(subDomain);
		Countor countor = new Countor().setSubDomain(subDomain);
		setAttr("Site", site);
		setAttr("Channel", channel);
		setAttr("Content", content);
		setAttr("Navi", navi);
		setAttr("Countor", countor);
		setAttr("Request", getParaData());
		if(subDomain == null) render(view);
		else render(subDomain, view);

		if(site.getUseCountor() == 1){
			if(type == Type.INDEX) countorSer.access(subDomain);
			else if(type == Type.CHANNEL) countorSer.access(subDomain, channel.getCode(), channel.getCaption());
			else if(type == Type.CONTENT) countorSer.access(subDomain, channel.getCode(), channel.getCaption(), content.getId(), content.getCaption());
		}
		
//		new Thread(new Runnable() {
//			@Override
//			public void run() {
//				if(site.getUseCountor() == 1){
//					if(type == Type.INDEX) countorSer.access(subDomain);
//					else if(type == Type.CHANNEL) countorSer.access(subDomain, channel.getCode(), channel.getCaption());
//					else if(type == Type.CONTENT) countorSer.access(subDomain, channel.getCode(), channel.getCaption(), content.getId(), content.getCaption());
//				}
//			}
//		}).start();
	}
	
}
