package itez.plat.site.controller;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.List;

import javax.imageio.ImageIO;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Page;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EHttp;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EProp;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.pic.EPicKit;
import itez.plat.site.ModuleConfig;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.model.Info;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.InfoService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/content", summary = "网站文章管理", view = "/")
public class SiteContentController extends EControllerMgr {

	@Inject
	InfoService infoSer;
	
	@Inject
	ChannelService channelSer;
	
	@Inject
	ContentService contentSer;
	
	public void index(String subDomain){
		if(EStr.isNull(subDomain)) subDomain = "";
		Channel indexChannel = channelSer.findByCode(subDomain, ModuleConfig.INDEX_CODE);
		List<Channel> channels = channelSer.getTreeChannels(subDomain);
		String pid = getPara("pid", indexChannel.getId());
		Integer page = getParaToInt("page", 1);
		Page<Content> contents = contentSer.getPageByChannelId(pid, page, 20, true);
		List<Info> sites = infoSer.getInfos();
		setAttr("pid", pid);
		setAttr("indexChannel", indexChannel);
		setAttr("channels", channels);
		setAttr("contents", contents);
		setAttr("subDomain", subDomain);
		setAttr("sites", EJson.toJsonFilter(sites, "subDomain", "caption"));
		render("content.html");
	}
	
	public void add(String subDomain, String pid){
		if(EStr.isNull(subDomain)) subDomain = "";
		setAttr("pid", pid);
		setAttr("subDomain", subDomain);
		render("content-add.html");
	}
	
	public void addContent(){
		EPara paras = paramPack(false);
		String channelId = paras.get("pid");
		String subDomain = paras.get("subDomain", "");
		
		File picFile = paras.getFileObj("pic");
		String picUrl = "", thumUrl = "";
		if(picFile != null){
			String picPath = picFile.getAbsolutePath();
			BufferedImage thum = EPicKit.use().compress(picPath, 0.5f, 300, 200);
			picUrl = getUpload(picFile);
			thumUrl = getUpload(thum);
		}
		
		Content content = new Content();
		content.setChannelId(channelId);
		content.setSubDomain(subDomain);
		content.setCaption(paras.get("caption"));
		content.setSubCaption(paras.get("subCaption"));
		content.setCaptionColor(paras.get("captionColor"));
		content.setLink(paras.get("link"));
		content.setSummary(paras.get("summary"));
		content.setAuthor(paras.get("author"));
		content.setContent(paras.get("content"));
		content.setSort(paras.getInt("sort", 0));
		if(EStr.notEmpty(picUrl)) content.setPic(picUrl);
		if(EStr.notEmpty(thumUrl)) content.setThum(thumUrl);
		contentSer.save(content);
		
		redirect(attr().getCtrl() + "?subDomain=" + subDomain + "&pid=" + channelId);
	}
	
	public void modify(String pid, String id){
		Content content = contentSer.findById(id);
		setAttr("pid", pid);
		setAttr("content", EJson.toJson(content));
		render("content-modify.html");
	}
	
	public void modifyContent(){
		EPara paras = paramPack(false);
		
		String id = paras.get("id");
		Content content = contentSer.findById(id);
		String subDomain = content.getSubDomain();
		String channelId = content.getChannelId();
		
		File picFile = paras.getFileObj("pic");
		String picUrl = "", thumUrl = "";
		if(picFile != null){
			String picPath = picFile.getAbsolutePath();
			BufferedImage thum = EPicKit.use().compress(picPath, 0.5f, 300, 200);
			picUrl = getUpload(picFile);
			thumUrl = getUpload(thum);
		}

		content.setCaption(paras.get("caption"));
		content.setSubCaption(paras.get("subCaption"));
		content.setCaptionColor(paras.get("captionColor"));
		content.setLink(paras.get("link"));
		content.setSummary(paras.get("summary"));
		content.setAuthor(paras.get("author"));
		content.setContent(paras.get("content"));
		content.setSort(paras.getInt("sort", 0));
		if(EStr.notEmpty(picUrl)) content.setPic(picUrl);
		if(EStr.notEmpty(thumUrl)) content.setThum(thumUrl);
		
		contentSer.update(content);
		
		redirect(attr().getCtrl() + "?subDomain=" + subDomain + "&pid=" + channelId);
	}
	
	public void catchContent(String wxUrl){
		String html = EHttp.me.get(wxUrl);
		Document doc = Jsoup.parse(html);
		Element container = doc.getElementById("img-content");
        String title = container.select("h2.rich_media_title").text();
        Element content = container.getElementById("js_content");
		content.select("script").remove();
		content.removeAttr("style");
		Elements imgs = content.select("img");
        String TempPath = EProp.FileUploadTemp;
		for (int i = 0, len = imgs.size(); i < len; i++) {
			Element img = imgs.get(i);
	        String imgUrl = img.attr("data-src");
	        if (EStr.isEmpty(imgUrl)) continue;
	        byte[] imgByte = EHttp.me.getByte(imgUrl);
	        if(imgByte == null) continue;
	        String imgType = imgUrl.split("\\?")[1].split("\\=")[1];
			try {
		        ByteArrayInputStream imgIn = new ByteArrayInputStream(imgByte);
		        BufferedImage imgBuff = ImageIO.read(imgIn);
		        File imgTemp = new File(TempPath.concat("thu.").concat(imgType));
		        ImageIO.write(imgBuff, imgType, imgTemp);
		        imgIn.close();
		        String imgPath = getUpload(imgTemp);
		        img.attr("data-src", imgPath).attr("src", imgPath).removeClass("raw-image").addClass("lazy-load");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		//renderHtml(content.outerHtml());
		ERet ret = ERet.ok("title", title).set("content", content.outerHtml());
		renderJson(ret);
	}
	
	public void removeContent(String subDomain, String pid, String ids){
		if(EStr.isNull(subDomain)) subDomain = "";
		contentSer.deleteByIds(ids);
		redirect(attr().getCtrl() + "?subDomain=" + subDomain + "&pid=" + pid);
	}
	
}
