package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.upload.UploadFile;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EStr;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Info;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.InfoService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/channel", summary = "网站栏目管理", view = "/")
public class SiteChannelController extends EControllerMgr {

	@Inject
	InfoService infoSer;
	
	@Inject
	ChannelService channelSer;
	
	public void index(String subDomain){
		if(EStr.isNull(subDomain)) subDomain = "";
		List<Info> sites = infoSer.getInfos();
		Channel indexChannel = channelSer.getIndexChannel(subDomain);
		List<Channel> channels = channelSer.getAllChannels(subDomain);
		setAttr("pid", getPara("pid", indexChannel.getId()));
		setAttr("indexChannel", indexChannel);
		setAttr("channels", channels);
		setAttr("subDomain", subDomain);
		setAttr("sites", EJson.toJsonFilter(sites, "subDomain", "caption"));
		render("channel.html");
	}
	
	public void add(String subDomain, String pid){
		if(EStr.isNull(subDomain)) subDomain = "";
		setAttr("pid", pid);
		setAttr("subDomain", subDomain);
		render("channel-add.html");
	}
	
	public void addChannel(){
		UploadFile picFile = getFile("pic");
		String picUrl = picFile != null ? getUpload(picFile.getFile()) : "";

		String subDomain = getPara("subDomain");
		if(EStr.isNull(subDomain)) subDomain = "";
		String pid = getPara("pid");
		Channel parent = channelSer.findById(pid);
		Channel last = channelSer.getLastChannel(subDomain, pid);
		Integer sort = last == null ? 1 : last.getSort() + 1;
		String path = String.format("%s_%s", parent.getPath(), EStr.addPrefix(sort, 3));
		
		Channel channel = new Channel();
		channel.setPid(pid);
		channel.setPath(path);
		channel.setSort(sort);

		String code = getPara("code");
		String icon = getPara("icon");
		String caption = getPara("caption");
		String subCaption = getPara("subCaption");
		String content = getPara("content");
		String channelTemp = getPara("channelTemp");
		String contentTemp = getPara("contentTemp");
		channel.setSubDomain(subDomain);
		channel.setCode(code);
		channel.setIcon(icon);
		channel.setPic(picUrl);
		channel.setCaption(caption);
		channel.setSubCaption(subCaption);
		channel.setContent(content);
		channel.setChannelTemp(channelTemp);
		channel.setContentTemp(contentTemp);
		
		channelSer.addChannel(channel);
		
		redirect(attr().getCtrl() + "?subDomain=" + subDomain + "&pid=" + pid);
	}
	
	public void modify(String pid, String id){
		Channel channel = channelSer.findById(id);
		setAttr("pid", pid);
		setAttr("channel", EJson.toJson(channel));
		render("channel-modify.html");
	}
	
	public void modifyChannel(){
		UploadFile picFile = getFile("pic");
		String picUrl = picFile != null ? getUpload(picFile.getFile()) : "";
		
		String id = getPara("id");
		Channel channel = channelSer.findById(id);
		String pid = channel.getPid();
		
		String code = getPara("code");
		String icon = getPara("icon");
		String caption = getPara("caption");
		String subCaption = getPara("subCaption");
		String content = getPara("content");
		String channelTemp = getPara("channelTemp");
		String contentTemp = getPara("contentTemp");
		
		channel.setCode(code);
		channel.setIcon(icon);
		if(EStr.notEmpty(picUrl)) channel.setPic(picUrl);
		channel.setCaption(caption);
		channel.setSubCaption(subCaption);
		channel.setContent(content);
		channel.setChannelTemp(channelTemp);
		channel.setContentTemp(contentTemp);
		
		channelSer.modifyChannel(channel);
		
		redirect(attr().getCtrl() + "/?subDomain=" + channel.getSubDomain() + "&pid=" + pid);
	}
	
	public void removeChannel(String subDomain, String pid, String ids){
		if(EStr.isNull(subDomain)) subDomain = "";
		channelSer.removeChannels(subDomain, ids);
		redirect(attr().getCtrl() + "?subDomain=" + subDomain + "&pid=" + pid);
	}
	
	public void sortChannel(String subDomain, String pid, String opt, String ids){
		if(EStr.isNull(subDomain)) subDomain = "";
		channelSer.sort(subDomain, pid, opt, ids);
		redirect(attr().getCtrl() + "?subDomain=" + subDomain + "&pid=" + pid);
	}
	
}
