package itez.plat.site.controller;

import java.io.File;
import java.util.List;

import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.upload.UploadFile;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.site.model.BackupHis;
import itez.plat.site.service.BackupHisService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/backup", summary = "网站备份", view = "/")
public class SiteBackupController extends EControllerMgr {

	@Inject
	BackupHisService bakSer;
	
	public void index(String type){
		List<Record> types = bakSer.getBackTypes();
		List<BackupHis> list = bakSer.getBackHis(type);
		setAttr("types", EJson.toJson(types));
		setAttr("list", EJson.toJson(list));
		setAttr("type", type);
		render("backup.html");
	}
	
	public void create(){
		List<Record> types = bakSer.getBackTypes();
		setAttr("types", EJson.toJson(types));
		render("backupCreate.html");
	}
	
	public void createEvent(){
		EPara paras = paramPack();
		BackupHis bak = paras.getModel(BackupHis.class);
		if(bak.getBtype().equals("content") && (EStr.isEmpty(bak.getDfrom()))){
			setFlashMsg("请输入数据日期范围！");
			redirect(attr().getCtrl().concat("/create"));
			return;
		}else if(!bak.getBtype().equals("content")){
			bak.setDfrom(null);
		}
		try {
			bak.setDend(bak.getDfrom());	//暂时不开放多个年份数据备份，只备份一年
			bakSer.create(bak);
			setFlashMsg("正在创建备份，可以离开当前页面，备份完成后状态将会变成“处理完毕”。");
			redirect(attr().getCtrl());
		} catch (Exception e) {
			setFlashMsg(e.getMessage());
			redirect(attr().getCtrl().concat("/create"));
		}
	}
	
	public void remove(String ids){
		try {
			bakSer.removeBak(ids);
			setFlashMsg("备份删除成功！");
			redirect(attr().getCtrl());
		} catch (Exception e) {
			setFlashMsg(e.getMessage());
			redirect(attr().getCtrl());
		}
	}
	
	public void download(String id){
		File file = bakSer.download(id);
		renderFile(file);
	}
	
	public void upload(){
		render("backupLoad.html");
	}
	
	public void uploadEvent(){
		UploadFile upload = getFile("file");
		File file = upload.getFile();
		String fileName = file.getName();
		if(fileName.split("\\.")[1] != "zip"){
			setFlashMsg("备份文件格式不符合要求，请上传zip格式的压缩包文件！");
			redirect(attr().getCtrl().concat("/upload"));
		}
		try {
			bakSer.upload(file);
			setFlashMsg("备份文件上传成功！");
			redirect(attr().getCtrl());
		} catch (Exception e) {
			setFlashMsg(e.getMessage());
			redirect(attr().getCtrl().concat("/upload"));
		}
	}
	
	public void restore(String id){
		try {
			bakSer.restore(id);
			setFlashMsg("正在使用备份还原，可以离开当前页面，还原完成后状态将会变成“处理完毕”。");
			redirect(attr().getCtrl());
		} catch (Exception e) {
			setFlashMsg(e.getMessage());
		}
		redirect(attr().getCtrl());
	}
	
}
