package itez.plat.site.controller;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.model.Info;

@ControllerDefine(key = "/", summary = "主站", view = "/")
public class IndexController extends SiteController {
	
	public void index(){
		Info site = infoSer.getInfo();
		Channel channel = channelSer.getIndexChannel("");
		String view = channel.getChannelTemp();
		if(!tempSer.checkTemp(null, view)){
			renderEmptySite();
			return;
		}
		renderSite(Type.INDEX, site, channel, new Content(), null, view);
	}
	
	public void channel(){
		String code = getPara(0);
		if(EStr.isEmpty(code)){
			renderText("未知栏目！");
			return;
		}
		Info site = infoSer.getInfo();
		Channel channel = channelSer.findByCode(code);
		if(null == channel){
			renderText("栏目不存在！");
			return;
		}
		String view = channel.getChannelTemp();
		if(!tempSer.checkTemp(null, view)){
			renderEmptySite();
			return;
		}
		renderSite(Type.CHANNEL, site, channel, new Content(), null, view);
	}
	
	public void content(){
		String id = getPara(0);
		if(EStr.isEmpty(id)){
			renderText("未知文章！");
			return;
		}
		Info site = infoSer.getInfo();
		Content content = contentSer.findById(id);
		if(null == content){
			renderText("文章不存在！");
			return;
		}
		Channel channel = channelSer.findById(content.getChannelId());
		if(null == channel){
			renderText("栏目不存在！");
			return;
		}
		String view = channel.getContentTemp();
		if(!tempSer.checkTemp(null, view)){
			renderEmptySite();
			return;
		}
		renderSite(Type.CONTENT, site, channel, content, null, view);
	}
	
}
