package itez.plat.quick.service.impl;

import java.util.Map;

import com.google.inject.Singleton;

import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.kit.ERet;
import itez.kit.eval.EvalFactory;
import itez.kit.eval.IEngine;
import itez.plat.quick.service.ScriptService;

@Define
@Singleton
public class ScriptServiceImpl extends EService implements ScriptService {

	private StringBuilder context;
	
	public ScriptServiceImpl(){
		context = new StringBuilder();
		context.append("var EUid = Java.type('itez.kit.EUid');");
		context.append("var EStr = Java.type('itez.kit.EStr');");
		context.append("var ENum = Java.type('itez.kit.ENum');");
		context.append("var ECode = Java.type('itez.kit.ECode');");
		context.append("var EHash = Java.type('com.jfinal.kit.HashKit');");
		context.append("var EDate = Java.type('itez.kit.EDate');");
		context.append("var ERegex = Java.type('itez.kit.ERegex');");
		context.append("var EJson = Java.type('itez.kit.EJson');");
		context.append("function getService(moduleCode, serviceName){");
		context.append("	var Ioc = Java.type('itez.core.runtime.service.Ioc');");
		context.append("	var type = Java.type('itez.plat.' + moduleCode + '.service.' + serviceName);");
		context.append("	var service = Ioc.get(type.class);");
		context.append("	return service;");
		context.append("}");
	}
	
	public void evalParams(String script, Map<String, Object> params){
		IEngine eng = EvalFactory.me.getEngine();
		StringBuilder sb = new StringBuilder();
		sb.append("(function(params){");
		sb.append(context);
		sb.append(script);
		sb.append("})(binding);");
		eng.eval(sb.toString(), ERet.create("binding", params));
	}
	
	public <T> T eval(String script){
		IEngine eng = EvalFactory.me.getEngine();
		StringBuilder sb = new StringBuilder();
		sb.append("(function(){");
		sb.append(context);
		sb.append("return ").append(script);
		sb.append("})();");
		return eng.eval(sb.toString());
	}
	
	public <T> T eval(String script, Map<String, Object> para){
		IEngine eng = EvalFactory.me.getEngine();
		StringBuilder sb = new StringBuilder();
		sb.append("(function(para){");
		sb.append(context);
		sb.append("return ").append(script);
		sb.append("})(binding);");
		return eng.eval(sb.toString(), ERet.create("binding", para));
	}
	
}
