package itez.plat.quick.service.impl;

import java.util.List;

import com.google.inject.Inject;
import com.google.inject.Singleton;

import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.plat.quick.logic.Qds;
import itez.plat.quick.logic.QdsImplSql;
import itez.plat.quick.logic.QdsMode;
import itez.plat.quick.logic.QdsType;
import itez.plat.quick.model.DsModel;
import itez.plat.quick.model.DsModelParams;
import itez.plat.quick.service.DsModelParamsService;
import itez.plat.quick.service.DsModelService;
import itez.plat.quick.service.QdsService;

@Define
@Singleton
public class QdsServiceImpl extends EService implements QdsService {

	@Inject
	private DsModelService modelSer;
	
	@Inject
	private DsModelParamsService paramsSer;
	
	@Override
	public Qds load(String modelCode) {
		DsModel model = modelSer.findByCode(modelCode);
		if(model == null) throw new RuntimeException("未找到对应的模型：" + modelCode);
		List<DsModelParams> params = paramsSer.getByModel(model.getId());
		QdsMode mode = QdsMode.valueOf(model.getMode());
		QdsType type = QdsType.valueOf(model.getType());
		Qds qds = null;
		
		switch (mode) {
		default:
			qds = new QdsImplSql();
			break;
		}
		
		qds.setCode(model.getCode());
		qds.setCaption(model.getCaption());
		qds.setModule(model.getModule());
		qds.setMode(mode);
		qds.setType(type);
		qds.setExpr(model.getExpr());
		qds.setRemarks(model.getRemarks());
		qds.setParams(params);
		return qds;
	}
	
}
