package itez.plat.quick.logic;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

import itez.kit.EStr;
import itez.plat.quick.model.DsModelParams;

@SuppressWarnings({"rawtypes", "unchecked"})
public class QdsImplSql extends QdsBase implements Qds {
	
	@Override
	public Qds query() {
		if(getType() != QdsType.SELECT){
			ex = new RuntimeException("类型不匹配");
			return this;
		}
		SqlPara sqlPara = Db.getSqlParaByString(expr, generatorParams(null));
		list = Db.use(module).find(sqlPara);
		return this;
	}
	
	@Override
	public Qds query(Map params) {
		if(getType() != QdsType.SELECT){
			ex = new RuntimeException("类型不匹配");
			return this;
		}
		SqlPara sqlPara = Db.getSqlParaByString(expr, generatorParams(params));
		list = Db.use(module).find(sqlPara);
		return this;
	}

	@Override
	public Qds page(int pageNumber, int pageSize) {
		if(getType() != QdsType.SELECT){
			ex = new RuntimeException("类型不匹配");
			return this;
		}
		SqlPara sqlPara = Db.getSqlParaByString(expr, generatorParams(null));
		Page<Record> page = Db.use(module).paginate(pageNumber, pageSize, sqlPara);
		list = page.getList();
		paged = true;
		this.pageNumber = page.getPageNumber();
		this.pageSize = page.getPageSize();
		totalPage = page.getTotalPage();
		totalRow = page.getTotalRow();
		return this;
	}

	@Override
	public Qds page(int pageNumber, int pageSize, Map params) {
		if(getType() != QdsType.SELECT){
			ex = new RuntimeException("类型不匹配");
			return this;
		}
		SqlPara sqlPara = Db.getSqlParaByString(expr, generatorParams(params));
		Page<Record> page = Db.use(module).paginate(pageNumber, pageSize, sqlPara);
		list = page.getList();
		paged = true;
		this.pageNumber = page.getPageNumber();
		this.pageSize = page.getPageSize();
		totalPage = page.getTotalPage();
		totalRow = page.getTotalRow();
		return this;
	}
	
	@Override
	public Qds execute() {
		if(getType() == QdsType.SELECT){
			ex = new RuntimeException("类型不匹配");
			return this;
		}
		SqlPara sqlPara = Db.getSqlParaByString(expr, generatorParams(null));
		executeResult = Db.use(module).update(sqlPara);
		return this;
	}
	
	@Override
	public Qds execute(Map params) {
		if(getType() == QdsType.SELECT){
			ex = new RuntimeException("类型不匹配");
			return this;
		}
		SqlPara sqlPara = Db.getSqlParaByString(expr, generatorParams(params));
		executeResult = Db.use(module).update(sqlPara);
		return this;
	}
	
	private Map generatorParams(Map params){
		List<DsModelParams> modelParams = getParams();
		Map paramsMap = Maps.newHashMap();
		modelParams.forEach(modelParam -> {
			String val = modelParam.getDefault();
			if(EStr.notEmpty(val)) val = exec(val, params);
			paramsMap.put(modelParam.getCode(), val);
		});
		return paramsMap;
	}

}
