package itez.plat.quick.logic;

import java.util.List;
import java.util.Map;

import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.EContext;
import itez.kit.EJson;
import itez.kit.ERet;
import itez.kit.EWeb;
import itez.kit.El;
import itez.plat.quick.model.DsModelParams;

@SuppressWarnings("rawtypes")
public abstract class QdsBase implements Qds {
	
	protected QdsMode mode;
	protected QdsType type;

	protected String module;
	protected String code;
	protected String caption;
	protected String expr;
	protected String remarks;
	
	protected List<DsModelParams> params;

	protected List<Record> list;

	protected boolean paged = false;
	protected int pageNumber;
	protected int pageSize;
	protected int totalPage;
	protected int totalRow;
	
	protected int executeResult;
	protected RuntimeException ex;
	
	protected String exec(String expr, Map params){
		Map<String, String> requestParams = EWeb.getParamMap(EContext.getRequest());
		ERet ret = ERet.create().set(requestParams);
		if(params != null) ret.set(params);
		return El.exec(expr, ret);
	}
	
	public QdsMode getMode() {
		return mode;
	}
	public void setMode(QdsMode mode) {
		this.mode = mode;
	}
	public QdsType getType() {
		return type;
	}
	public void setType(QdsType type) {
		this.type = type;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getCaption() {
		return caption;
	}
	public void setCaption(String caption) {
		this.caption = caption;
	}
	public String getModule() {
		return module;
	}
	public void setModule(String moduleCode) {
		this.module = moduleCode;
	}
	public String getExpr() {
		return expr;
	}
	public void setExpr(String expr) {
		this.expr = expr;
	}
	public String getRemarks() {
		return remarks;
	}
	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}
	public List<DsModelParams> getParams() {
		return params;
	}
	public void setParams(List<DsModelParams> params) {
		this.params = params;
	}
	public List<Record> getList() {
		return list;
	}
	public String getJson() {
		return list == null ? "[]" : EJson.toJson(list);
	}
	public boolean getPaged() {
		return paged;
	}
	public int getPageNumber() {
		return pageNumber;
	}
	public int getPageSize() {
		return pageSize;
	}
	public int getTotalPage() {
		return totalPage;
	}
	public int getTotalRow() {
		return totalRow;
	}
	public int getExecuteResult() {
		return executeResult;
	}
	public RuntimeException getException() {
		return ex;
	}

}
