package itez.plat.quick.logic;

import java.util.List;
import java.util.Map;

import com.jfinal.plugin.activerecord.Record;

import itez.plat.quick.model.DsModelParams;

@SuppressWarnings("rawtypes")
public interface Qds {
	
	Qds query();
	Qds query(Map params);
	Qds page(int pageNumber, int pageSize);
	Qds page(int pageNumber, int pageSize, Map params);
	Qds execute();
	Qds execute(Map params);
	
	QdsMode getMode();
	void setMode(QdsMode mode);
	QdsType getType();
	void setType(QdsType type);
	String getCode();
	void setCode(String code);
	String getCaption();
	void setCaption(String caption);
	String getModule();
	void setModule(String moduleCode);
	String getExpr();
	void setExpr(String expr);
	String getRemarks();
	void setRemarks(String remarks);
	
	List<DsModelParams> getParams();
	void setParams(List<DsModelParams> params);
	
	List<Record> getList();
	String getJson();
	
	boolean getPaged();
	int getPageNumber();
	int getPageSize();
	int getTotalPage();
	int getTotalRow();
	
	RuntimeException getException();
	
}
