package itez.plat.quick.logic;

import java.util.Map;

import com.google.common.collect.Maps;

import itez.core.runtime.service.EService;
import itez.core.runtime.service.Ioc;
import itez.kit.EClass;
import itez.kit.EStr;
import itez.plat.quick.service.QdsService;

public class ModuleWrapper {

	private String moduleCode;
	private static final Map<String, EService> serviceCache = Maps.newConcurrentMap();
	private static final Map<String, Qds> qdsCache = Maps.newConcurrentMap();
	
	public ModuleWrapper(String code){
		this.moduleCode = code;
	}
	
	/**
	 * 根据Model名称返回服务对象
	 * 
	 * @param modelName
	 * @return
	 */
	public EService getSer(String modelName){
		if(serviceCache.containsKey(modelName)) return serviceCache.get(modelName);
		String clazz = String.format("itez.plat.%s.service.%sService", moduleCode, EStr.toUpperCaseFirst(modelName));
		Class<?> serviceClazz = EClass.forName(clazz);
		EService ser = serviceClazz == null ? null : Ioc.get(serviceClazz);
		serviceCache.put(modelName, ser);
		return ser;
	}
	
	/**
	 * 返回快捷数据源
	 * 
	 * @param modelCode
	 * @return
	 */
	public Qds getDs(String modelCode){
		if(qdsCache.containsKey(modelCode)) return qdsCache.get(modelCode);
		QdsService qdsSer = Ioc.get(QdsService.class);
		Qds qds = qdsSer.load(modelCode);
		qdsCache.put(modelCode, qds);
		return qds;
	}
	
}
