package itez.plat.quick.logic;

import java.util.Map;

import com.google.common.collect.Maps;

import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;

public class ModuleUtil {

	private static final Map<String, ModuleWrapper> moduleCache = Maps.newConcurrentMap();
	
	/**
	 * 返回模块包装类
	 * @param moduleCode
	 * @return
	 */
	public static ModuleWrapper get(String moduleCode){
		ModuleBase base = ModuleManager.me.getModule(moduleCode);
		if(base == null) return null;
		if(moduleCache.containsKey(moduleCode)) return moduleCache.get(moduleCode);
		ModuleWrapper wrapper = new ModuleWrapper(moduleCode);
		moduleCache.put(moduleCode, wrapper);
		return wrapper;
	}
	
}
