package itez.plat.quick.controller;

import java.util.List;
import java.util.Map;

import com.google.inject.Inject;
import com.jfinal.kit.Kv;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.ERet;
import itez.kit.El;
import itez.plat.quick.logic.ModuleUtil;
import itez.plat.quick.service.QdsService;
import itez.plat.quick.service.ScriptService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/meta", summary = "元数据管理", view = "/")
public class MetaController extends EControllerMgr {

	@Inject
	ScriptService scriptSer;

	@Inject
	QdsService qdsSer;
	
	@SuppressWarnings("unchecked")
	public void index(String clazz){
		ERet params = ERet.create("id", "aaa").set("name", "sss").set("roles", new String[]{"a", "b", "c"});
		StringBuilder sb = new StringBuilder();
		sb.append("var dictSer = getService('base', 'DictService');");
		sb.append("params.dicts = dictSer.getByGroup('fxxly');");
		sb.append("params.id = EUid.generator();");
		scriptSer.evalParams(sb.toString(), params);
		renderJson(params);
	}
	
	public void service(){
		List<Map<String, Object>> list= scriptSer.eval("getService('base', 'DictService').getByGroup('fxxly')");
		renderJson(list);
	}
	
	public void arr(){
		List<Map<String, Object>> map= scriptSer.eval("[{id:'x',name:'netwild'},{id:'y',name:'zmy'}]");
		renderJson(map);
	}
	
	public void obj(String code){
		Map<String, String> map= scriptSer.eval("{id: EUid.generator(), name: 'netwild'}");
		renderJson(map);
	}
	
	public void qds(){
		String list = ModuleUtil.get("main").getDs("test").query(Kv.by("domain", "zwcm")).getJson();
		renderJson(list);
	}
	
	public void module(){
		String expr = "Module.get('main').getDs('test').query({'domain':'zwcm'}).getJson()";
		String ret = El.exec(expr);
		renderJson(ret);
	}
	
}
