package itez.plat.main.service.impl;

import itez.core.runtime.service.EService;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.EWeb;
import itez.plat.main.model.CompBank;
import itez.plat.main.model.CompWx;
import itez.plat.main.service.CompBankService;
import itez.plat.main.service.CompWxService;
import itez.plat.main.service.WxService;
import itez.core.runtime.EContext;
import itez.core.runtime.service.Define;
import itez.weixin.api.PaymentApi;
import itez.weixin.api.PaymentApi.TradeType;
import itez.weixin.kit.PaymentKit;

import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;

import com.beust.jcommander.internal.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class WxServiceImpl extends EService implements WxService {

	@Inject
	CompWxService cwxs;
	@Inject
	CompBankService cbs;
	
	/**
	 * 统一支付
	 * @param isApp 是否小程序下单
	 * @param user 用户对象
	 * @param wxCfg 微信配置对象
	 * @param request HttpServletRequest
	 * @param tradeType 支付类型：TradeType.JSAPI（公众号支付） TradeType.NATIVE（原生扫码） TradeType.APP TradeType.WAP
	 * @param productId 商品ID
	 * @param orderId 订单ID
	 * @param body 订单内容
	 * @param fee 金额（单位：元）
	 * @param callBackUrl 回调地址
	 * @return
	 * @throws Exception
	 */
    public ERet payFor(String appId, String openId, TradeType tradeType, String productId, String orderId, String body, BigDecimal fee, String callBackUrl) throws Exception {
		// 统一下单文档地址：https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=9_1
    	//CompWxInterface wxCfg = getCompWxConfig(domain);
    	CompWx comp = cwxs.findByAppId(appId);
    	if(comp == null) throw new Exception("单位的appId设置不正确！");
    	CompBank bank = cbs.findBankConfig();
    	if(bank == null) throw new Exception("还未设置商户信息！");
		String businessId = bank.getBusinessId();
		String businessKey = bank.getBusinessKey();
		String ip = EWeb.getIpAddr(EContext.getRequest());
		if (EStr.isEmpty(ip)) ip = "127.0.0.1";
		int totao_fee = fee.multiply(new BigDecimal("100")).intValue();
		Map<String, String> params = Maps.newHashMap();
		params.put("appid", appId); // 微信公众平台AppId
		params.put("mch_id", businessId); // 微信商户ID
		params.put("body", body); // 商品描述
		if(tradeType == TradeType.NATIVE) params.put("product_id", productId); // 商品ID（Native模式必传）
		if(tradeType == TradeType.JSAPI) params.put("openid", openId); // openid（JSAPI模式必传）
		params.put("out_trade_no", orderId); // 订单号
		params.put("total_fee", totao_fee + ""); // 费用金额
		params.put("spbill_create_ip", ip); // 客户端IP
		params.put("trade_type", tradeType.name()); // 交易类型
		params.put("nonce_str", System.currentTimeMillis() / 1000 + ""); // 随机数
		params.put("notify_url", callBackUrl); // 支付完成后的回调地址，不允许带参数

		String sign = PaymentKit.createSign(params, businessKey); // 使用以上参数集合及商户密钥生成签名
		params.put("sign", sign);

		String xmlResult = PaymentApi.pushOrder(params); // 调用统一支付接口
		Map<String, String> result = PaymentKit.xmlToMap(xmlResult); // 接口返回
		String return_code = result.get("return_code"); // 返回通信标识
		String return_msg = result.get("return_msg"); // 错误原因
		if (EStr.isEmpty(return_code) || !"SUCCESS".equals(return_code)) throw new Exception(return_msg); // 通信失败
		String result_code = result.get("result_code"); // 返回业务结果
		String err_code_des = result.get("err_code_des"); // 业务错误描述
		if (EStr.isEmpty(result_code) || !"SUCCESS".equals(result_code)) throw new Exception(err_code_des); // 支付失败
		String prepayId = result.get("prepay_id"); //预支付会话标识，用于后续接口调用中使用，该值有效期为2小时
		String codeUrl = result.get("code_url"); // 用于生成二维码，展示给用户进行扫码支付
		//return (tradeType == TradeType.NATIVE) ? code_url : prepay_id;
		
		ERet ret = ERet.create();
		ret.set("codeUrl", codeUrl); //换取支付二维码地址，本地支付需要
		if(tradeType == TradeType.JSAPI){ //公众号支付，还需要生成签名
			String timestamp = (System.currentTimeMillis() / 1000) + "";
			String nonceStr = $UUID();
			String packageStr = "prepay_id=" + prepayId;
			String signType = "MD5";
			Map<String, String> wxMap = new TreeMap<String, String>();
			wxMap.put("appId", appId);
			wxMap.put("timeStamp", timestamp); //生成签名时timeStamp中的S大写！
			wxMap.put("nonceStr", nonceStr);
			wxMap.put("package", packageStr);
			wxMap.put("signType", signType);
			String paySign = PaymentKit.createSign(wxMap, businessKey);
			ret.set("timestamp", timestamp);
			ret.set("nonceStr", nonceStr);
			ret.set("package", packageStr);
			ret.set("signType", signType);
			ret.set("paySign", paySign);
			/*
			System.out.println("============================");
			System.out.println("appId = " + appId);
			System.out.println("timeStamp = " + timestamp);
			System.out.println("nonceStr = " + nonceStr);
			System.out.println("package = " + packageStr);
			System.out.println("signType = " + signType);
			System.out.println("businessKey = " + businessKey);
			System.out.println("paySign = " + paySign);
			System.out.println("============================");
			*/
		}
		return ret;
    }

}