package itez.plat.main.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;

import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.core.runtime.service.IService;
import itez.kit.EDate;
import itez.kit.ELog;
import itez.kit.EStr;
import itez.plat.main.model.User;
import itez.plat.main.service.UserService;
import itez.weixin.api.ApiResult;
import itez.weixin.api.app.WxaUserApi;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserWxServiceImpl extends EService implements IService {

	@Inject
	UserService us;

	/**
	 * 小程序登录
	 * @param codeJs
	 * @param userInfo
	 * @param domain
	 * @return
	 * @throws Exception
	 */
	public String wxAppLogin(String codeJs, String userInfo, String domain) throws Exception {
		String sid = "";
		WxaUserApi api = new WxaUserApi();
		ApiResult ret = api.getSessionKey(codeJs);
		if(null != ret && ret.isSucceed()){
			String openId = ret.getStr("openid");
			String unionId = ret.getStr("unionid");
			String sessionKey = ret.getStr("session_key");
			try {
				User user = null;
				if(EStr.notEmpty(unionId)) user = us.findByUnionId(unionId);
				if(user == null) user = us.findByWxaOpenId(openId);
				JSONObject userJson = JSON.parseObject(userInfo);
				sid = addUserWxApp(user, openId, unionId, sessionKey, domain, userJson);
				if(EStr.isEmpty(sid)) throw new Exception("维护用户信息时发生错误");
			} catch (Exception e) {
				throw new Exception(e);
			}
		}else{
			throw new RuntimeException("返回错误：" + ret.getErrorMsg());
		}
		return sid;
	}
	
	/**
	 * 添加小程序用户
	 * @param user
	 * @param openId
	 * @param unionId
	 * @param sessionKey
	 * @param domain
	 * @param userJson
	 * @return
	 */
	private String addUserWxApp(User user, String openId, String unionId, String sessionKey, String domain, JSONObject userJson) {
		String sid = "";
		if(null != userJson){
			String nickName = userJson.getString("nickName");
			String avatarUrl = userJson.getString("avatarUrl");
			String gender = userJson.getString("gender");
			String province = userJson.getString("province");
			String city = userJson.getString("city");
			String country = userJson.getString("country");
			String language = userJson.getString("language");
			if(user == null){ //新用户
				user = new User();
				user.setWxaOpenId(openId);
				user.setUnionId(unionId);
				user.setWxaSessionKey(sessionKey);
				user.setDomain(domain);
				user.setCaption(nickName);
				user.setHeader(avatarUrl);
				user.setSex(gender);
				user.setCountry(country);
				user.setProvince(province);
				user.setCity(city);
				user.setLanguage(language);
				user.setSalt(HashKit.generateSaltForSha256());
				user.setLevel(0);
				user.setMember(0);
				user.setFollowed(1);
				user.setFollowDate(EDate.getDate());
				user.save();
				sid = user.getId();
				ELog.info("小程序新用户：{}（openid：{}）", nickName, openId);
			}else{ //老用户
				sid = user.getId();
				user.setWxaSessionKey(sessionKey);
				user.setCaption(nickName);
				user.setHeader(avatarUrl);
				user.setUnionId(unionId);
				user.update();
				ELog.info("小程序老用户：{}（openid：{}）", nickName, openId);
			}
		}
		return sid;
	}
	
	/**
	 * 设置小程序用户的FormId，用于发送模板消息
	 * @param userId
	 * @param formId
	 */
	@Cache.del(cache="USER_BY_ID", key="#(userId)")
	public void setWxaFormId(String userId, String formId) {
		User user = us.findById(userId);
		user.set("wxaFormId", formId).update();
	}

	/**
	 * 获取小程序用户的FormId，用于发送模板消息
	 * @param userId
	 * @return
	 */
	public String getWxaFormId(String userId) {
		return us.findById(userId).getWxaFormId();
	}
	
}
