package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.poi.ECell;
import itez.kit.poi.EPoi;
import itez.kit.poi.ERow;
import itez.kit.poi.ESheet;
import itez.kit.poi.Excel;
import itez.kit.poi.XlsHeader;
import itez.kit.poi.XlsHeaderItem;
import itez.kit.poi.XlsWriter;
import itez.plat.main.model.Dept;
import itez.plat.main.model.Role;
import itez.plat.main.model.User;
import itez.plat.main.service.DeptService;
import itez.plat.main.service.PermService;
import itez.plat.main.service.RoleService;
import itez.plat.main.service.UserIOService;
import itez.plat.main.service.UserService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;
import com.jfinal.plugin.activerecord.Record;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserServiceImpl extends EModelService<User> implements UserService, IUserService {

	@Inject
	UserIOService uioService;

	@Inject
	RoleService roleService;

	@Inject
	PermService permService;
	
	@Inject
	DeptService deptService;
	
	private User emptyUser;
	
	public UserServiceImpl(){
		emptyUser = new User();
		emptyUser.setId(null);
		emptyUser.setCaption("匿名用户");
		emptyUser.setUsed(1);
	}
	
	@Override
	public User getEmptyUser() {
		return this.emptyUser;
	}

	@Override
	@Cache.able(cache="USER_BY_ID", key="userId")
	public User findById(String userId) {
		return super.findById(userId);
	}

	@Override
	@Cache.able(cache="USER_BY_EMAIL", key="email")
	public User findByEmail(String email) {
		Querys qs = Querys.and(Query.eq("email", email)).add(Query.eq("used", 1));
		List<User> users = select(qs, null, 1, false);
		return users.size() > 0 ? users.get(0) : null;
	}

	@Override
	@Cache.able(cache="USER_BY_EMAIL", key="domain + '.' + email")
	public User findByEmail(String domain, String email) {
		Querys qs1 = Querys.or(Query.eq("domain", domain)).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("email", email));
		List<User> users = select(qs2, null, 1, false);
		return users.size() > 0 ? users.get(0) : null;
	}

	@Override
	@Cache.able(cache="USER_BY_PHONE", key="phone")
	public User findByPhone(String phone) {
		Querys qs = Querys.and(Query.eq("phone", phone)).add(Query.eq("used", 1));
		List<User> users = select(qs, null, 1, false);
		return users.size() > 0 ? users.get(0) : null;
	}

	@Override
	@Cache.able(cache="USER_BY_PHONE", key="domain + '.' + phone")
	public User findByPhone(String domain, String phone) {
		Querys qs1 = Querys.or(Query.eq("domain", domain)).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("phone", phone));
		List<User> users = select(qs2, null, 1, false);
		return users.size() > 0 ? users.get(0) : null;
	}

	@Override
	@Cache.able(cache="USER_BY_IDNUM", key="idNum")
	public User findByIdNum(String idNum) {
		Querys qs = Querys.and(Query.eq("idNum", idNum)).add(Query.eq("used", 1));
		List<User> users = select(qs, null, 1, false);
		return users.size() > 0 ? users.get(0) : null;
	}

	@Override
	@Cache.able(cache="USER_BY_IDNUM", key="domain + '.' + idNum")
	public User findByIdNum(String domain, String idNum) {
		Querys qs1 = Querys.or(Query.eq("domain", domain)).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("idNum", idNum)).add(Query.eq("used", 1));
		List<User> users = select(qs2, null, 1, false);
		return users.size() > 0 ? users.get(0) : null;
	}

	@Override
	@Cache.able(cache="USER_BY_LOGIN", key="loginName")
	public User findByLogin(String loginName) {
		Querys qs = Querys.and(Query.eq("loginName", loginName)).add(Query.eq("used", 1));
		List<User> users = select(qs, "id", 1, false);
		return users.size() > 0 ? users.get(0) : null;
	}

	@Override
	@Cache.able(cache="USER_BY_LOGIN", key="domain + '.' + loginName")
	public User findByLogin(String domain, String loginName) {
		Querys qs1 = Querys.or(Query.eq("domain", domain)).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("loginName", loginName));
		List<User> users = select(qs2, "used desc, id", 1, false);
		if(users.size() > 0) return users.get(0);
		else{
			ELog.debug(">>> 用户登录账号不存在（IN DB）：{}.{}.{}", domain, loginName);
			return null;
		}
	}

	@Override
	public User findByLogin(String domain, String loginName, String passWord) {
		User user = findByLogin(domain, loginName);
		if(user != null){
			String pass = HashKit.md5(String.format("%s%s", passWord, user.getSalt()));
			if(pass.equals(user.getLoginPass())) return user;
			ELog.debug(">>> 用户登录密码错误：{}.{}.{}", domain, loginName, passWord);
		}
		ELog.debug(">>> 用户登录账号不存在：{}.{}.{}", domain, loginName);
		return null;
	}

	@Override
	public boolean checkRole(IUser user, String roleCode) {
		if(user.getLevel() == 2) return true;
		if(EStr.isEmpty(roleCode)) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		String[] roles = EStr.toArray(roleIds);
		if(roles.length == 0) return false;
		return Arrays.stream(roles).anyMatch(r -> r.equals(roleCode));
	}

	@Override
	public boolean checkRoles(IUser user, String... roleCodeArr) {
		if(user.getLevel() == 2) return true;
		if(roleCodeArr == null || roleCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		String[] roles = EStr.toArray(roleIds);
		if(roles.length == 0) return false;
		for(String roleCode : roleCodeArr){
			if(!Arrays.stream(roles).anyMatch(r -> r.equals(roleCode))) return false;
		}
		return true;
		/*
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		Set<String> rolesHas = roles.stream().map(r -> r.getCode()).collect(Collectors.toSet());
		Set<String> rolesReq = new HashSet<String>(Arrays.asList(roleCodeArr));
		rolesHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		if(!rolesHas.retainAll(rolesReq)) return false;
		else return rolesReq.size() == rolesHas.size();
		*/
	}

	@Override
	public boolean checkRolesAny(IUser user, String... roleCodeArr) {
		if(user.getLevel() == 2) return true;
		if(roleCodeArr == null || roleCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		String[] roles = EStr.toArray(roleIds);
		if(roles.length == 0) return false;
		for(String roleCode : roleCodeArr){
			if(Arrays.stream(roles).anyMatch(r -> r.equals(roleCode))) return true;
		}
		return false;
		/*
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		Set<String> rolesHas = roles.stream().map(r -> r.getCode()).collect(Collectors.toSet());
		Set<String> rolesReq = new HashSet<String>(Arrays.asList(roleCodeArr));
		rolesHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		return rolesHas.retainAll(rolesReq);
		*/
	}

	@Override
	public boolean checkPerm(IUser user, String permCode) {
		if(user.getLevel() == 2) return true;
		if(EStr.isEmpty(permCode)) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleService.findByCodes(roleIds);
		if(roles == null || roles.size() == 0) return false;
		String[] permIds = roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
		if(permIds == null || permIds.length == 0) return false;
		return Arrays.stream(permIds).anyMatch(p -> p.equals(permCode));
	}

	@Override
	public boolean checkPerms(IUser user, String... permCodeArr) {
		if(user.getLevel() == 2) return true;
		if(permCodeArr == null || permCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		String[] permIds = roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
		if(permIds == null || permIds.length == 0) return false;
		for(String permCode : permCodeArr){
			if(!Arrays.stream(permIds).anyMatch(p -> p.equals(permCode))) return false;
		}
		return true;
		/*
		List<Perm> perms = permService.findByIda(permIds);
		if(perms == null || perms.size() == 0) return false;
		Set<String> permsHas = perms.stream().map(p -> p.getCode()).collect(Collectors.toSet());
		Set<String> permsReq = new HashSet<String>(Arrays.asList(permCodeArr));
		permsHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		if(!permsHas.retainAll(permsReq)) return false;
		else return permsReq.size() == permsHas.size();
		*/
	}

	@Override
	public boolean checkPermsAny(IUser user, String... permCodeArr) {
		if(user.getLevel() == 2) return true;
		if(permCodeArr == null || permCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		String[] permIds = roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
		if(permIds == null || permIds.length == 0) return false;
		for(String permCode : permCodeArr){
			if(!Arrays.stream(permIds).anyMatch(p -> p.equals(permCode))) return true;
		}
		return false;
		/*
		List<Perm> perms = permService.findByIda(permIds);
		if(perms == null || perms.size() == 0) return false;
		Set<String> permsHas = perms.stream().map(p -> p.getCode()).collect(Collectors.toSet());
		Set<String> permsReq = new HashSet<String>(Arrays.asList(permCodeArr));
		permsHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		return permsHas.retainAll(permsReq);
		*/
	}

	@Override
	public List<User> getUsers(String ids){
		Querys qs = Querys.and(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs);
	}
	
	/**
	 * 返回指定部门的成员列表
	 * @param deptId
	 * @return
	 */
	@Override
	public List<User> getInsUsers(String deptId){
		return getInsUsers(deptId, null);
	}
	
	/**
	 * 返回指定部门的成员列表
	 * @param deptId
	 * @return
	 */
	@Override
	public List<User> getInsUsers(String deptId, String type){
		Querys qs = Querys.and(Query.eq("member", 1)).add(Query.le("level", $user().getLevel()));
		if(EStr.notEmpty(deptId)) qs.add(Query.eq("deptId", deptId));
		if(EStr.notEmpty(type)) qs.add(Query.eq("type", type));
		List<User> list = select(qs, "level desc, id", null, "id, idNum, num, type, caption, loginName, roleIds, phone, email, postId, header, birthday, sex");
		return list;
	}
	
	/**
	 * 返回指定部门的成员列表，包括在职和离职的所有人员
	 * @param deptId
	 * @return
	 */
	@Override
	public List<User> getInsUsersAll(String deptId){
		Querys qs = Querys.and(Query.eq("domain", $domain())).add(Query.eq("member", 1));
		if(deptId != null) qs.add(Query.eq("deptId", deptId));
		List<User> list = select(qs, "level desc, id", null, false, "id, idNum, num, type, caption, loginName, roleIds, phone, email, postId, header, birthday, sex");
		return list;
	}

	/**
	 * 返回指定部门已离职的成员列表
	 */
	@Override
	public List<User> getLeavedUsers(String deptId) {
		Querys qs = Querys.and(Query.eq("domain", $domain())).add(Query.eq("member", 1)).add(Query.eq("used", 0)).add(Query.le("level", $user().getLevel()));
		if(deptId != null) qs.add(Query.eq("deptId", deptId));
		List<User> list = select(qs, "level desc, id", null, false, "id, idNum, num, type, caption, loginName, roleIds, phone, email, postId, header, birthday, sex");
		return list;
	}

	@Override
	public List<User> searchInsUser(String keyword){
		return searchInsUser(keyword, null);
	}

	@Override
	public List<User> searchInsUser(String keyword, String deptId){
		Querys qs = Querys.and(Query.eq("member", 1)).add(Query.eq("used", 1)).add(Query.ne("level", 2));
		if(deptId != null) qs.add(Query.eq("deptId", deptId));
		if(EStr.notEmpty(keyword)){
			Querys lk = Querys.or(Query.like("caption", "%" + keyword + "%")).add(Query.like("idNum", "%" + keyword + "%")).add(Query.like("num", "%" + keyword + "%"));
			qs.add(lk);
		}
		List<User> list = select(qs, "level desc, id", null, "id, idNum, num, type, caption, loginName, roleIds, phone, email, postId, header, birthday, sex");
		return list;
	}

	@Override
	public List<User> searchInsUser(Querys qs) {
		Querys qs1 = Querys.and(Query.eq("member", 1)).add(Query.eq("used", 1)).add(Query.ne("level", 2));
		if(qs != null) qs1.add(qs);
		List<User> list = select(qs1, "level desc, id", null, "id, idNum, num, type, caption, loginName, roleIds, phone, email, postId, header, birthday, sex");
		return list;
	}
	
	/**
	 * 添加新用户
	 * @param user
	 */
	@Override
	public void add(User user, String loginPass){
		uioService.addUser(user, loginPass);
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 */
	@Override
	public void modify(User user){
		uioService.modifyUser(user);
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 */
	@Override
	public void modify(User user, String loginPass){
		uioService.modifyUser(user, loginPass);
	}
	
	/**
	 * 删除用户信息
	 * @param domain
	 * @param ids
	 */
	@Override
	public void remove(String ids){
		List<User> users = getUsers(ids);
		users.forEach(user -> uioService.removeUser(user));
	}
	
	/**
	 * 恢复用户信息
	 * @param ids
	 */
	@Override
	public void reback(String ids){
		List<User> users = getUsers(ids);
		users.forEach(user -> uioService.rebackUser(user));
	}

	/**
	 * 移动用户
	 */
	@Override
	public void move(String ids, String pidOrig, String pidTo) {
		List<User> users = getUsers(ids);
		users.forEach(user -> uioService.move(user, pidTo));
	}
	
	/**
	 * 微信相关
	 */

	@Override
	public User findByUnionId(String unionId){
		return super.selectFirst(Querys.and(Query.eq("unionId", unionId)));
	}

	@Override
	public User findByWxOpenId(String openId){
		return super.selectFirst(Querys.and(Query.eq("wxOpenId", openId)));
	}

	@Override
	public User findByWxaOpenId(String openId){
		return super.selectFirst(Querys.and(Query.eq("wxaOpenId", openId)));
	}

	@Override
	public User findByWxeOpenId(String openId){
		return super.selectFirst(Querys.and(Query.eq("wxeOpenId", openId)));
	}

	@Override
	public User loginByTypeName(String type, String loginName) {
		Querys qs = Querys.and(Query.eq("type", type)).add(Query.eq("loginName", loginName));
		return selectFirst(qs);
	}

	@Override
	public User loginByTypeNameOrIdNum(String type, String loginName) {
		Querys qs1 = Querys.or(Query.eq("idNum", loginName)).add(Query.eq("loginName", loginName));
		Querys qs2 = Querys.and(Query.eq("type", type)).add(qs1);
		return selectFirst(qs2);
	}

	@Override
	public XlsWriter export(Dept dept) {
		return export(dept, null);
	}

	@Override
	public XlsWriter export(Dept dept, String type) {
		List<User> userModels = getInsUsers(dept.getId(), type);
		List<Record> users = parseRecords(userModels);		
		String fileName = "成员列表（".concat(dept.getCaption()).concat("）.xls");
		XlsWriter xls = XlsWriter.create(fileName);
		XlsHeader header = XlsHeader.create();
		header.addItem(new XlsHeaderItem("id", "ID"));
		header.addItem(new XlsHeaderItem("caption", "姓名"));
		header.addItem(new XlsHeaderItem("idNum", "身份证"));
		header.addItem(new XlsHeaderItem("sex", "性别（1男0女）"));
		header.addItem(new XlsHeaderItem("phone", "手机号"));
		header.addItem(new XlsHeaderItem("email", "Email"));
		header.addItem(new XlsHeaderItem("loginName", "登录名称"));
		header.addItem(new XlsHeaderItem("loginPass", "登录密码"));
		xls.putSheet("Sheet1", users, header, false);
		xls.generator();
		return xls;
	}
	

	@Override
	public int imports(String deptId, File file){
		return importsForDept(deptId, file, null);
	}

	@Override
	public int imports(String deptId, File file, String type, boolean multiDept) {
		return multiDept ? importsMultiDept(file, type) : importsForDept(deptId, file, type);
	}
	
	/**
	 * <p>
	 * 导入到指定部门
	 * </p>
	 * 
	 * @param deptId
	 * @param file
	 * @param type
	 * @return
	 */
	private int importsForDept(String deptId, File file, String type){
		String domain = $domain();
		Excel excel = null;
		try {
			excel = EPoi.load(file);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException("解析Excel文件时发送错误，请重新操作。");
		}
		ESheet sheet = excel.getSheet(0);
		int celCnt = sheet.getCellCount();
		int rowCnt = sheet.getRowCount();
		if(celCnt < 8 || rowCnt < 2) throw new RuntimeException("文件中未发现有效数据，导入失败。");
		String[] fields = { "id", "caption", "idNum", "sex", "phone", "email", "loginName", "loginPass" };
		Map<String, Integer> fieldIndex = Maps.newHashMap();
		List<ERow> rows = sheet.getRows();

		//数据列对照
		ERow header = rows.get(0);
		header.getCells().forEach(cell -> {
			Object val = cell.getValue();
			if(val != null){
				String caption = val.toString();
				if(ArrayUtils.contains(fields, caption)){
					fieldIndex.put(caption, cell.getCellIndex());
				}
			}
		});
		
		//必要数据列预审
		StringBuilder sb = new StringBuilder();
		Arrays.stream(fields).forEach(f -> {
			if(!fieldIndex.containsKey(f)){
				sb.append("，").append(f);
			}
		});
		if(sb.length() > 0) throw new RuntimeException("缺少必要数据列：" + sb.substring(1));
		
		int cnt = 0;
		
		//开始执行导入
		for(ERow row : rows){
			if(row.getIndex() < 2) continue;
			List<ECell> cells = row.getCells();
			Object idObj = cells.get(fieldIndex.get("id")).getValue();
			Object captionObj = cells.get(fieldIndex.get("caption")).getValue();
			Object idNumObj = cells.get(fieldIndex.get("idNum")).getValue();
			Object sexObj = cells.get(fieldIndex.get("sex")).getValue();
			Object phoneObj = cells.get(fieldIndex.get("phone")).getValue();
			Object emailObj = cells.get(fieldIndex.get("email")).getValue();
			Object loginNameObj = cells.get(fieldIndex.get("loginName")).getValue();
			Object loginPassObj = cells.get(fieldIndex.get("loginPass")).getValue();
			
			if(EStr.isEmpty(captionObj) || EStr.isEmpty(loginNameObj)) continue;
			
			String id = formatNum(idObj);
			String caption = formatNum(captionObj);
			String idNum = formatNum(idNumObj);
			String sex = formatNum(sexObj);
			String phone = formatNum(phoneObj);
			String email = formatNum(emailObj);
			String loginName = formatNum(loginNameObj);
			String loginPass = formatNum(loginPassObj);
			
			if(EStr.isEmpty(id)){
				
				User uex = findByLogin(domain, loginName);
				if(uex != null) continue;
				if(EStr.notEmpty(idNum)){
					uex = findByIdNum(domain, idNum);
					if(uex != null) continue;
				}
				if(EStr.notEmpty(phone)){
					uex = findByPhone(domain, phone);
					if(uex != null) continue;
				}
				if(EStr.notEmpty(email)){
					uex = findByEmail(domain, email);
					if(uex != null) continue;
				}
				
				User u = new User();
				u.setMember(1).setLevel(0).setDeptId(deptId).setType(type);
				u.setCaption(caption).setSex(sex).setIdNum(idNum).setPhone(phone).setEmail(email).setLoginName(loginName);
				add(u, EStr.ifEmpty(loginPass, loginName));
				cnt++;
			}else{
				User u = findById(id);
				if(u != null && u.getDeptId().equals(deptId)){

					User uex = findByLogin(domain, loginName);
					if(uex != null && !uex.getId().equals(id)) continue;
					if(EStr.notEmpty(idNum)){
						uex = findByIdNum(domain, idNum);
						if(uex != null && !uex.getId().equals(id)) continue;
					}
					if(EStr.notEmpty(phone)){
						uex = findByPhone(domain, phone);
						if(uex != null && !uex.getId().equals(id)) continue;
					}
					if(EStr.notEmpty(email)){
						uex = findByEmail(domain, email);
						if(uex != null && !uex.getId().equals(id)) continue;
					}
					
					if(EStr.notEmpty(caption)) u.setCaption(caption);
					if(EStr.notEmpty(sex)) u.setSex(sex);
					if(EStr.notEmpty(idNum)) u.setIdNum(idNum);
					if(EStr.notEmpty(phone)) u.setPhone(phone);
					if(EStr.notEmpty(email)) u.setEmail(email);
					if(EStr.notEmpty(loginName)) u.setLoginName(loginName);
					if(EStr.notEmpty(loginPass)) u.setLoginPass(HashKit.md5(loginPass + u.getSalt()));
					modify(u);
					cnt++;
				}
			}
		}
		
		return cnt;
	}
	
	/**
	 * <p>
	 * 根据导入模板中的“dept”部门名称列自动导入到所属部门
	 * </p>
	 * 
	 * @param file
	 * @param type
	 * @return
	 */
	private int importsMultiDept(File file, String type){
		String domain = $domain();
		Excel excel = null;
		try {
			excel = EPoi.load(file);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException("解析Excel文件时发送错误，请重新操作。");
		}
		ESheet sheet = excel.getSheet(0);
		int celCnt = sheet.getCellCount();
		int rowCnt = sheet.getRowCount();
		if(celCnt < 8 || rowCnt < 2) throw new RuntimeException("文件中未发现有效数据，导入失败。");
		String[] fields = { "dept", "caption", "role", "idNum", "phone", "sex", "email", "loginName", "loginPass" };
		Map<String, Integer> fieldIndex = Maps.newHashMap();
		List<ERow> rows = sheet.getRows();

		//数据列对照
		ERow header = rows.get(0);
		header.getCells().forEach(cell -> {
			Object val = cell.getValue();
			if(val != null){
				String caption = val.toString();
				if(ArrayUtils.contains(fields, caption)){
					fieldIndex.put(caption, cell.getCellIndex());
				}
			}
		});
		
		//必要数据列预审
		StringBuilder sb = new StringBuilder();
		Arrays.stream(fields).forEach(f -> {
			if(!fieldIndex.containsKey(f)){
				sb.append("，").append(f);
			}
		});
		if(sb.length() > 0) throw new RuntimeException("缺少必要数据列：" + sb.substring(1));
		
		Map<String, Boolean> userCaptionRepeat = Maps.newHashMap();		//姓名重复检测
		Map<String, String> deptCaptionDict = Maps.newHashMap();		//部门名称索引
		int cnt = 0;
		
		List<Dept> depts = deptService.getAllDepts();
		depts.forEach(dept -> {
			deptCaptionDict.put(dept.getCaption(), dept.getId());
		});
		
		//开始执行导入
		for(ERow row : rows){
			if(row.getIndex() < 2) continue;
			List<ECell> cells = row.getCells();
			Object deptObj = cells.get(fieldIndex.get("dept")).getValue();
			Object captionObj = cells.get(fieldIndex.get("caption")).getValue();
			Object roleObj = cells.get(fieldIndex.get("role")).getValue();
			Object idNumObj = cells.get(fieldIndex.get("idNum")).getValue();
			Object phoneObj = cells.get(fieldIndex.get("phone")).getValue();
			Object sexObj = cells.get(fieldIndex.get("sex")).getValue();
			Object emailObj = cells.get(fieldIndex.get("email")).getValue();
			Object loginNameObj = cells.get(fieldIndex.get("loginName")).getValue();
			Object loginPassObj = cells.get(fieldIndex.get("loginPass")).getValue();
			
			if(EStr.isEmpty(deptObj) || EStr.isEmpty(captionObj) || EStr.isEmpty(loginNameObj)) continue;
			
			String dept = formatNum(deptObj);
			String caption = formatNum(captionObj);
			String roles = formatNum(roleObj);
			String idNum = formatNum(idNumObj);
			String phone = formatNum(phoneObj);
			String sex = formatNum(sexObj);
			String email = formatNum(emailObj);
			String loginName = formatNum(loginNameObj);
			String loginPass = formatNum(loginPassObj);
			
			if(userCaptionRepeat.containsKey(caption)) continue;
			
			String deptId = deptCaptionDict.get(dept);
			if(EStr.isEmpty(deptId)) continue;

			User uex = findByLogin(domain, loginName);
			if(uex != null) continue;
			if(EStr.notEmpty(idNum)){
				uex = findByIdNum(domain, idNum);
				if(uex != null) continue;
			}
			if(EStr.notEmpty(phone)){
				uex = findByPhone(domain, phone);
				if(uex != null) continue;
			}
			if(EStr.notEmpty(email)){
				uex = findByEmail(domain, email);
				if(uex != null) continue;
			}
			
			User u = new User();
			u.setMember(1).setLevel(0).setRoleIds(roles).setType(type).setDeptId(deptId);
			u.setCaption(caption).setSex(sex).setIdNum(idNum).setPhone(phone).setEmail(email).setLoginName(loginName);
			add(u, EStr.ifEmpty(loginPass, loginName));
			userCaptionRepeat.put(caption, true);
			cnt++;
		}
		return cnt;
	}
	
	private String formatNum(Object val){
		String valStr = EStr.isEmpty(val) ? "" : val.toString();
		return valStr.replaceAll("\\.0$", "");
	}

	/**
	 * 返回指定用户的默认机构
	 */
	@Override
	public Dept getMyDept(User user) {
		Dept dept;
		if(user.getLevel() == 0){
			dept = deptService.findById(user.getDeptId());
		}else{
			dept = deptService.createRootDept();
		}
		return dept;
	}

	/**
	 * 返回指定用户的机构树型
	 */
	@Override
	public List<Dept> getMyDeptTree(User user) {
		Dept dept = getMyDept(user);
		return deptService.getAllDepts(dept.getId());
	}

}