package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.kit.EStr;
import itez.plat.main.model.User;
import itez.plat.main.service.LeavedService;
import itez.plat.main.service.UserIOService;
import itez.core.runtime.service.Define;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserIOServiceImpl extends EModelService<User> implements UserIOService {
	
	@Inject
	LeavedService leavedSer;
	
	/**
	 * 添加新用户
	 * @param user
	 * @return
	 */
	public User addUser(User user, String loginPass){
		user.setSalt(HashKit.generateSaltForSha512());
		user.setLoginPass(HashKit.md5(loginPass + user.getSalt()));
		user.save();
		return user;
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 * @return
	 */
	public User modifyUser(User user){
		user.update();
		removeCache(user);
		return user;
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 * @return
	 */
	public User modifyUser(User user, String loginPass){
		if(EStr.notEmpty(loginPass)) user.setLoginPass(HashKit.md5(loginPass + user.getSalt()));
		user.update();
		removeCache(user);
		return user;
	}
	
	/**
	 * 删除用户信息
	 * @param domain
	 * @param ids
	 */
	public void removeUser(User user){
		user.disable();
		leavedSer.userLeave(user.getId());
		removeCache(user);
	}
	
	/**
	 * 恢复用户信息
	 * @param domain
	 * @param ids
	 */
	public void rebackUser(User user){
		user.enable();
		leavedSer.userBack(user.getId());
	}

	/**
	 * 移动用户
	 */
	@Override
	public void move(User user, String pid) {
		user.setDeptId(pid).update();
		removeCache(user);
	}
	
	/**
	 * 移除缓存
	 * @param user
	 */
	private void removeCache(User user){
		ECacheKit.remove("USER_BY_ID", user.getId());
		ECacheKit.remove("USER_BY_LOGIN", String.format("%s.%s", user.getDomain(), user.getLoginName()));
		if(EStr.notEmpty(user.getEmail())) ECacheKit.remove("USER_BY_EMAIL", String.format("%s.%s", user.getDomain(), user.getEmail()));
		if(EStr.notEmpty(user.getPhone())) ECacheKit.remove("USER_BY_PHONE", String.format("%s.%s", user.getDomain(), user.getPhone()));
		if(EStr.notEmpty(user.getIdNum())) ECacheKit.remove("USER_BY_IDNUM", String.format("%s.%s", user.getDomain(), user.getIdNum()));
	}

}