package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.plat.main.model.Role;
import itez.plat.main.service.RoleService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class RoleServiceImpl extends EModelService<Role> implements RoleService {

	@Override
	@Cache.able(cache="ROLE_BY_ID", key="id")
	public Role findById(String id) {
		return super.findById(id);
	}

	@Override
	@Cache.able(cache="ROLE_BYIDS", key="EStr.parseArray(ids)")
	public List<Role> findByIda(String...ids){
		return super.findByIda(ids);
	}

	@Override
	@Cache.able(cache="ROLE_BYCODES", key="codes")
	public List<Role> findByCodes(String codes){
		return super.findByCodes(codes);
	}

	@Override
	@Cache.able(cache="ROLE_BYMODULE", key="moduleCode")
	public List<Role> getByModule(String moduleCode) {
		Querys qs = Querys.and(Query.eq("moduleId", moduleCode));
		return select(qs);
	}

	@Override
	@Cache.able(cache="ROLE_ALL", key="'ALL'")
	public List<Role> getAll() {
		return selectAll();
	}
	
	@Override
	@Cache.delAll(cache="ROLE_ALL")
	@Cache.delAll(cache="ROLE_BYIDS")
	@Cache.delAll(cache="ROLE_BYMODULE")
	public boolean save(Role model) {
		return super.save(model);
	}
	
	@Override
	@Cache.del(cache="ROLE_BY_ID", key="model.id")
	@Cache.delAll(cache="ROLE_ALL")
	@Cache.delAll(cache="ROLE_BYIDS")
	@Cache.delAll(cache="ROLE_BYMODULE")
	public boolean update(Role model) {
		return super.update(model);
	}
	
	@Override
	@Cache.del(cache="ROLE_BY_ID", key="idValue")
	@Cache.delAll(cache="ROLE_BYCODES")
	@Cache.delAll(cache="ROLE_ALL")
	@Cache.delAll(cache="ROLE_BYIDS")
	@Cache.delAll(cache="ROLE_BYMODULE")
	public boolean deleteById(String idValue) {
		return super.deleteById(idValue);
	}

}