package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.plat.main.model.Perm;
import itez.plat.main.service.PermService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class PermServiceImpl extends EModelService<Perm> implements PermService {

	@Override
	@Cache.able(cache="PERM_BY_ID", key="id")
	public Perm findById(String id) {
		return super.findById(id);
	}

	@Override
	@Cache.able(cache="PERM_BYIDS", key="EStr.parseArray(ids)")
	public List<Perm> findByIda(String...ids){
		return findByIda(ids);
	}

	@Override
	@Cache.able(cache="PERM_BYCODE", key="code")
	public Perm findByCode(String code){
		return findByCode(code);
	}

	@Override
	@Cache.able(cache="PERM_BYMODULE", key="moduleCode")
	public List<Perm> getByModule(String moduleCode) {
		Querys qs = Querys.and(Query.eq("moduleId", moduleCode));
		return select(qs);
	}
	
	@Override
	@Cache.delAll(cache="PERM_BYIDS")
	@Cache.delAll(cache="PERM_BYMODULE")
	public boolean save(Perm model) {
		return super.save(model);
	}
	
	@Override
	@Cache.del(cache="PERM_BY_ID", key="model.id")
	@Cache.del(cache="PERM_BY_CODE", key="model.code")
	@Cache.delAll(cache="PERM_BYIDS")
	@Cache.delAll(cache="PERM_BYMODULE")
	public boolean update(Perm model) {
		return super.update(model);
	}
	
	@Override
	@Cache.del(cache="PERM_BY_ID", key="idValue")
	@Cache.delAll(cache="PERM_BY_CODE")
	@Cache.delAll(cache="PERM_BYIDS")
	@Cache.delAll(cache="PERM_BYMODULE")
	public boolean deleteById(String idValue) {
		return super.deleteById(idValue);
	}

}