package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.pay.PayKit;
import itez.core.runtime.service.Define;
import itez.plat.main.model.PaymentChannel;
import itez.plat.main.service.PaymentChannelService;

import java.util.List;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.Record;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class PaymentChannelServiceImpl extends EModelService<PaymentChannel> implements PaymentChannelService {

	@Override
	public List<Record> getPaymentChannels() {
		List<Record> channels = Lists.newArrayList();
		channels.add(new Record().set("code", PayKit.Channel.CCB.name()).set("caption", PayKit.Channel.CCB.getCaption())); //建行聚合支付
		return channels;
	}

	@Override
	public List<PaymentChannel> getPaymentEnable() {
		Querys qs = Querys.and(Query.eq("enable", 1));
		return select(qs, null, null, "code", "caption");
	}
	
}