package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.ELog;
import itez.kit.exception.ErrException;
import itez.kit.log.ELogBase;
import itez.plat.main.model.Module;
import itez.plat.main.service.ModuleService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;
import itez.core.runtime.service.Define;

import java.util.List;
import java.util.Map;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ModuleServiceImpl extends EModelService<Module> implements ModuleService {

	private final static ELogBase log = ELog.log(ModuleService.class);

	@Override
	@Cache.able(cache="moduleService", key="id")
	public Module findById(String id) {
		return super.findById(id);
	}

	@Override
	@Cache.able(cache="moduleService", key="code")
	public Module findByCode(String code) {
		return super.findByCode(code);
	}
	
	@Cache.put(cache="moduleService", key="module.key")
	public Module create(Module module){
		if(super.save(module)) return module;
		else throw new ErrException("创建模块失败");
	}

	@Override
	@Cache.del(cache="moduleService", key="module.key")
	public boolean disable(Module module){
		if(super.disable(module)) return true;
		else throw new ErrException("停用模块失败");
	}

	@Override
	@Cache.del(cache="moduleService", key="module.key")
	public boolean enable(Module module){
		if(super.enable(module)) return true;
		else throw new ErrException("启用模块失败");
	}
	
	@Override
	@Cache.able
	public List<Module> findByIda(String...ids){
		return super.findByIda(ids);
	}
	
	/**
	 * 启动时同步模块表
	 */
	public void initModuleData(){
		List<Module> oldList = selectAll();
		Map<String, ModuleBase> map = ModuleManager.me.getModules();
		//处理无效的模块
		oldList.stream().forEach(m -> {
			if(!map.containsKey(m.getCode())){
				this.disable(m);
				log.info("停用模块：{} - {}", m.getCode(), m.getCaption());
			}else{
				ModuleBase m_cfg = map.get(m.getCode());
				m.setCaption(m_cfg.getModuleName());
				m.setPath(m_cfg.getModulePath());
				this.update(m);
			}
		});
		//处理新模块
		map.forEach((code, cfg) -> {
			List<Module> ms = select(Querys.and(Query.eq("code", code)), null, 1, false);
			Module m = ms.size() > 0 ? ms.get(0) : null;
			if(m == null){
				m = new Module();
				m.setCode(code);
				m.setPath(cfg.getModulePath());
				m.setCaption(cfg.getModuleName());
				this.create(m);
				log.info("发现新模块：{} - {}", code, cfg.getModuleName());
			}else if(!m.able()){
				this.enable(m);
				log.info("重新启用模块：{} - {}", code, cfg.getModuleName());
			}
		});
	}

}