package itez.plat.main.service.impl;

import itez.core.runtime.session.EAttr;
import itez.core.wrapper.controller.EController;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EFile;
import itez.kit.EStr;
import itez.core.runtime.EContext;
import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;
import itez.core.runtime.service.Define;
import itez.plat.main.model.Menu;
import itez.plat.main.service.MenuService;
import itez.plat.wrapper.service.ETreeService;

import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Lists;
import com.google.inject.Singleton;
import com.jfinal.aop.Invocation;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class MenuServiceImpl extends ETreeService<Menu> implements MenuService {
	
	@Override
	public Menu findById(String id) {
		return super.findById(id);
	}

	public List<Menu> getCompMenus(String mtype){
		return getCompMenus(mtype, null);
	}

	public List<Menu> getCompMenus(String mtype, String pid){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		qs.add(pid == null ? Query.nu("pid") : Query.eq("pid", pid));
		List<Menu> menus = select(Selector.select().where(qs));
		if(pid == null && (menus == null || menus.size() == 0)) menus = initMenu(mtype);
		menus.forEach(menu -> {
			if(menu.getFolder() == 1){
				List<Menu> subs = getCompMenus(mtype, menu.getId());
				if(null != subs && subs.size() > 0){
					menu.put("subs", subs);
				}
			}
		});
		return menus;
	}
	
	/**
	 * 初始化最基本的菜单
	 * @param mtype
	 * @return
	 */
	public List<Menu> initMenu(String mtype){
		List<Menu> menus = Lists.newArrayList();
		if(mtype.equals("menu")){
			//平台首页
			Menu indexMenu = new Menu();
			indexMenu.setMtype(mtype).setIco("fa fa-circle-o").setCaption("平台首页").setCommand("src:/plat").setPath("001").setFolder(0).setSort(1);
			save(indexMenu);
			menus.add(indexMenu);
			//系统设置
			Menu sysMenu = new Menu();
			sysMenu.setMtype(mtype).setIco("fa fa-cogs").setCaption("系统设置").setPath("002").setFolder(1).setSort(2);
			save(sysMenu);
			menus.add(sysMenu);
			//单位信息
			Menu compMenu = new Menu();
			compMenu.setMtype(mtype).setPid(sysMenu.getId()).setIco("fa fa-bank").setCaption("单位信息").setCommand("src:/plat/comp").setPath("002_001").setFolder(0).setSort(1);
			save(compMenu);
			//部门管理
			Menu deptMenu = new Menu();
			deptMenu.setMtype(mtype).setPid(sysMenu.getId()).setIco("fa fa-sitemap").setCaption("部门管理").setCommand("src:/plat/dept").setPath("002_002").setFolder(0).setSort(2);
			save(deptMenu);
			//成员管理
			Menu userMenu = new Menu();
			userMenu.setMtype(mtype).setPid(sysMenu.getId()).setIco("fa fa-user-o").setCaption("成员管理").setCommand("src:/plat/insUser").setPath("002_003").setFolder(0).setSort(3);
			save(userMenu);
		}
		return menus;
	}

	public List<Menu> getMenuTree(String mtype){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		return select(qs, "path");
	}
	
	public Menu getLastMenu(String mtype, String pid){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		return super.getLast(qs, pid);
	}
	
	public void sort(String mtype, String pid, String opt, String ids){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		super.sort(qs, pid, opt, ids);
	}
	
	public void init(String mtype, String moduleCode){
		ModuleBase module = ModuleManager.me.getModule(moduleCode);
		if(module == null) throw new RuntimeException("模块不存在！");
		
		String moduleView = module.getModuleView();
		String moduleMenu = moduleView + "/" + mtype + ".json";
		String menuJson = EFile.readInRes(moduleMenu);
		if(menuJson == null) throw new RuntimeException("模块的菜单文件（" + moduleMenu + "）不存在！");
		
		SqlPara sql = dbo().getSqlPara("main.cleanMenuByModule", Kv.by("moduleCode", moduleCode));
		dbo().update(sql);
		
		JSONArray roots = JSON.parseArray(menuJson);
		initLevel(mtype, moduleCode, null, roots);
	}
	
	private void initLevel(String mtype, String moduleCode, String pid, JSONArray menus){
		for(int i=0, cnt=menus.size(); i<cnt; i++){
			JSONObject menuJson = menus.getJSONObject(i);
			String ico = menuJson.getString("ico");
			String caption = menuJson.getString("caption");
			Integer folder = menuJson.getInteger("folder");
			String command = menuJson.getString("command");
			String authMode = menuJson.getString("authMode");
			String authCode = menuJson.getString("authCode");
			
			Menu parent = EStr.isEmpty(pid) ? null : findById(pid);
			Menu last = getLastMenu(mtype, pid);
			Integer sort = last == null ? 1 : last.getSort() + 1;
			String path = parent == null ? EStr.addPrefix(sort, 3) : String.format("%s_%s", parent.getPath(), EStr.addPrefix(sort, 3));
			Menu menu = new Menu();
			menu.setMtype(mtype);
			menu.setModuleCode(moduleCode);
			menu.setPid(pid);
			menu.setIco(ico);
			menu.setCaption(caption);
			menu.setCommand(command);
			menu.setAuthMode(authMode);
			menu.setAuthCode(authCode);
			menu.setFolder(folder);
			menu.setSort(sort);
			menu.setPath(path);
			save(menu);
			
			JSONArray subs = menuJson.getJSONArray("sub");
			if(subs != null && subs.size() > 0) initLevel(mtype, moduleCode, menu.getId(), subs);
		}
	}
	
	public void interceptorMenu(Invocation inv, String mtype){
		EController controller = (EController)inv.getController();
		EAttr attr = EContext.getAttr();
		
		final String menuActiveKey = "_m_";
		
		String clickMenu = controller.getPara(menuActiveKey);
		
		if(EStr.notEmpty(clickMenu)){
			if(clickMenu.equals("_index_")) clickMenu = "";
			EContext.getSession().setAttribute(menuActiveKey, clickMenu);
		}else{
			clickMenu = EContext.getSession().getAttr(menuActiveKey);
		}
		
		if(EStr.notEmpty(clickMenu)){
			int at = clickMenu.lastIndexOf("_");
			at = at == -1 ? 0 : at+1;
			String menuId = clickMenu.substring(at);
			String menuActiveName = findById(menuId).getCaption();
			attr.setItem("currentMenuId", clickMenu);
			attr.setItem("currentMenuName", menuActiveName);
			attr.setItem("currentMenuStr", String.format("%s=%s", menuActiveKey, clickMenu));
		}
		
		List<Menu> menus = getCompMenus(mtype);
		if(menus != null) attr.setItem("menusData", menus);
	}

}